/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.LoggerUtil;
import com.databend.jdbc.ParamMarker;
import com.databend.jdbc.RawStatement;
import com.databend.jdbc.RawStatementWrapper;
import com.databend.jdbc.SetParamRawStatement;
import com.databend.jdbc.StatementInfoWrapper;
import com.databend.jdbc.StatementType;
import com.databend.jdbc.log.DatabendLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class StatementUtil {
    @Generated
    private static final DatabendLogger log = LoggerUtil.getLogger(StatementUtil.class.getName());
    private static final String SET_PREFIX = "set";
    private static final Pattern SET_WITH_SPACE_REGEX = Pattern.compile("set ", 2);
    private static final String[] SELECT_KEYWORDS = new String[]{"show", "select", "describe", "exists", "explain", "with", "call"};

    public static boolean isQuery(String cleanSql) {
        if (StringUtils.isNotEmpty(cleanSql)) {
            cleanSql = cleanSql.replace("(", "");
            return StringUtils.startsWithAny(cleanSql.toLowerCase(), SELECT_KEYWORDS);
        }
        return false;
    }

    public static Optional<Pair<String, String>> extractParamFromSetStatement(@NonNull String cleanSql, String sql) {
        if (cleanSql == null) {
            throw new NullPointerException("cleanSql is marked non-null but is null");
        }
        if (StringUtils.startsWithIgnoreCase(cleanSql, SET_PREFIX)) {
            return StatementUtil.extractPropertyPair(cleanSql, sql);
        }
        return Optional.empty();
    }

    public static Map<Integer, String> extractColumnTypes(String sql) {
        LinkedHashMap<Integer, String> columnTypes = new LinkedHashMap<Integer, String>();
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String[] columns = matcher.group(1).split(",");
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i].trim();
                String type = column.substring(column.lastIndexOf(32) + 1).replace("'", "");
                columnTypes.put(i, type);
            }
        }
        return columnTypes;
    }

    public static List<StatementInfoWrapper> parseToStatementInfoWrappers(String sql) {
        return StatementUtil.parseToRawStatementWrapper(sql).getSubStatements().stream().map(StatementInfoWrapper::of).collect(Collectors.toList());
    }

    public static RawStatementWrapper parseToRawStatementWrapper(String sql) {
        ArrayList<RawStatement> subStatements = new ArrayList<RawStatement>();
        ArrayList<ParamMarker> subStatementParamMarkersPositions = new ArrayList<ParamMarker>();
        int subQueryStart = 0;
        int currentIndex = 0;
        char currentChar = sql.charAt(currentIndex);
        StringBuilder cleanedSubQuery = StatementUtil.isCommentStart(currentChar) ? new StringBuilder() : new StringBuilder(String.valueOf(currentChar));
        boolean isCurrentSubstringBetweenQuotes = currentChar == '\'';
        boolean isCurrentSubstringBetweenDoubleQuotes = currentChar == '\"';
        boolean isInSingleLineComment = false;
        boolean isInMultipleLinesComment = false;
        boolean isInComment = false;
        boolean foundSubqueryEndingSemicolon = false;
        int subQueryParamsCount = 0;
        while (currentIndex++ < sql.length() - 1) {
            boolean isPreviousCharInComment = isInComment;
            char previousChar = currentChar;
            currentChar = sql.charAt(currentIndex);
            isInSingleLineComment = StatementUtil.isInSingleLineComment(currentChar, previousChar, isCurrentSubstringBetweenQuotes, isInSingleLineComment);
            isInMultipleLinesComment = StatementUtil.isInMultipleLinesComment(currentChar, previousChar, isCurrentSubstringBetweenQuotes, isInMultipleLinesComment);
            isInComment = isInSingleLineComment || isInMultipleLinesComment;
            if (isInComment) continue;
            if (!isCurrentSubstringBetweenQuotes && StatementUtil.isEndingSemicolon(currentChar, previousChar, foundSubqueryEndingSemicolon, isPreviousCharInComment)) {
                foundSubqueryEndingSemicolon = true;
                if (StatementUtil.isEndOfSubquery(currentChar)) {
                    subStatements.add(RawStatement.of(sql.substring(subQueryStart, currentIndex), subStatementParamMarkersPositions, cleanedSubQuery.toString().trim()));
                    subStatementParamMarkersPositions = new ArrayList();
                    subQueryStart = currentIndex;
                    foundSubqueryEndingSemicolon = false;
                    cleanedSubQuery = new StringBuilder();
                }
            } else if (currentChar == '?' && !isCurrentSubstringBetweenQuotes && !isCurrentSubstringBetweenDoubleQuotes) {
                subStatementParamMarkersPositions.add(new ParamMarker(++subQueryParamsCount, currentIndex - subQueryStart));
            } else if (currentChar == '\'') {
                isCurrentSubstringBetweenQuotes = !isCurrentSubstringBetweenQuotes;
            } else if (currentChar == '\"') {
                boolean bl = isCurrentSubstringBetweenDoubleQuotes = !isCurrentSubstringBetweenDoubleQuotes;
            }
            if (StatementUtil.isCommentStart(currentChar) && !isCurrentSubstringBetweenQuotes) continue;
            cleanedSubQuery.append(currentChar);
        }
        subStatements.add(RawStatement.of(sql.substring(subQueryStart, currentIndex), subStatementParamMarkersPositions, cleanedSubQuery.toString().trim()));
        return new RawStatementWrapper(subStatements);
    }

    private static boolean isEndingSemicolon(char currentChar, char previousChar, boolean foundSubqueryEndingSemicolon, boolean isPreviousCharInComment) {
        if (foundSubqueryEndingSemicolon) {
            return true;
        }
        return ';' == previousChar && currentChar != ';' && !isPreviousCharInComment;
    }

    private static boolean isEndOfSubquery(char currentChar) {
        return currentChar != '-' && currentChar != '/' && currentChar != ' ' && currentChar != '\n';
    }

    private static boolean isCommentStart(char currentChar) {
        return currentChar == '-' || currentChar == '/';
    }

    private static boolean isInMultipleLinesComment(char currentChar, char previousChar, boolean isCurrentSubstringBetweenQuotes, boolean isInMultipleLinesComment) {
        if (!isCurrentSubstringBetweenQuotes && previousChar == '/' && currentChar == '*') {
            return true;
        }
        if (previousChar == '*' && currentChar == '/') {
            return false;
        }
        return isInMultipleLinesComment;
    }

    public static Map<Integer, Integer> getParamMarketsPositions(String sql) {
        RawStatementWrapper rawStatementWrapper = StatementUtil.parseToRawStatementWrapper(sql);
        return rawStatementWrapper.getSubStatements().stream().map(RawStatement::getParamMarkers).flatMap(Collection::stream).collect(Collectors.toMap(ParamMarker::getId, ParamMarker::getPosition));
    }

    public static Pair<Optional<String>, Optional<String>> extractDbNameAndTableNamePairFromCleanQuery(String cleanSql) {
        Optional<Object> from = Optional.empty();
        if (StatementUtil.isQuery(cleanSql)) {
            log.debug("Extracting DB and Table name for SELECT: {}", cleanSql);
            String withoutQuotes = StringUtils.replace(cleanSql, "'", "").trim();
            if (StringUtils.startsWithIgnoreCase(withoutQuotes, "select")) {
                int fromIndex = StringUtils.indexOfIgnoreCase(withoutQuotes, "from");
                if (fromIndex != -1) {
                    from = Optional.of(withoutQuotes.substring(fromIndex + "from".length()).trim().split(" ")[0]);
                }
            } else if (StringUtils.startsWithIgnoreCase(withoutQuotes, "DESCRIBE")) {
                from = Optional.of("tables");
            } else if (StringUtils.startsWithIgnoreCase(withoutQuotes, "SHOW")) {
                from = Optional.empty();
            } else {
                log.debug("Could not find table name for query {}. This may happen when there is no table.", cleanSql);
            }
        }
        return new ImmutablePair<Optional<String>, Optional<String>>(StatementUtil.extractDbNameFromFromPartOfTheQuery(from.orElse(null)), StatementUtil.extractTableNameFromFromPartOfTheQuery(from.orElse(null)));
    }

    public static List<StatementInfoWrapper> replaceParameterMarksWithValues(@NonNull Map<Integer, String> params, @NonNull String sql) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        RawStatementWrapper rawStatementWrapper = StatementUtil.parseToRawStatementWrapper(sql);
        return StatementUtil.replaceParameterMarksWithValues(params, rawStatementWrapper);
    }

    public static List<StatementInfoWrapper> replaceParameterMarksWithValues(@NonNull Map<Integer, String> params, @NonNull RawStatementWrapper rawStatement) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (rawStatement == null) {
            throw new NullPointerException("rawStatement is marked non-null but is null");
        }
        ArrayList<StatementInfoWrapper> subQueries = new ArrayList<StatementInfoWrapper>();
        for (int subqueryIndex = 0; subqueryIndex < rawStatement.getSubStatements().size(); ++subqueryIndex) {
            int offset = 0;
            RawStatement subQuery = rawStatement.getSubStatements().get(subqueryIndex);
            String subQueryWithParams = subQuery.getSql();
            if ((long)params.size() != rawStatement.getTotalParams()) {
                throw new IllegalArgumentException(String.format("The number of parameters passed does not equal the number of parameter markers in the SQL query. Provided: %d, Parameter markers in the SQL query: %d", params.size(), rawStatement.getTotalParams()));
            }
            for (ParamMarker param : subQuery.getParamMarkers()) {
                String value = params.get(param.getId());
                if (value == null) {
                    throw new IllegalArgumentException("No value for parameter marker at position: " + param.getId());
                }
                int currentPos = param.getPosition() + offset;
                if (currentPos >= subQuery.getSql().length() + offset) {
                    throw new IllegalArgumentException("The position of the parameter marker provided is invalid");
                }
                subQueryWithParams = subQueryWithParams.substring(0, currentPos) + value + subQueryWithParams.substring(currentPos + 1);
                offset += value.length() - 1;
            }
            Pair<String, String> additionalParams = subQuery.getStatementType() == StatementType.PARAM_SETTING ? ((SetParamRawStatement)subQuery).getAdditionalProperty() : null;
            subQueries.add(new StatementInfoWrapper(subQueryWithParams, UUID.randomUUID().toString().replace("-", ""), subQuery.getStatementType(), additionalParams, subQuery));
        }
        return subQueries;
    }

    private static Optional<String> extractTableNameFromFromPartOfTheQuery(String from) {
        return Optional.ofNullable(from).map(s -> s.replace("\"", "")).map(fromPartOfTheQuery -> {
            if (StringUtils.contains((CharSequence)fromPartOfTheQuery, ".")) {
                int indexOfTableName = StringUtils.lastIndexOf((CharSequence)fromPartOfTheQuery, ".");
                return fromPartOfTheQuery.substring(indexOfTableName + 1);
            }
            return fromPartOfTheQuery;
        });
    }

    private static Optional<String> extractDbNameFromFromPartOfTheQuery(String from) {
        return Optional.ofNullable(from).map(s -> s.replace("\"", "")).filter(s -> StringUtils.countMatches((CharSequence)s, ".") == 2).map(fromPartOfTheQuery -> {
            int dbNameEndPos = StringUtils.indexOf((CharSequence)fromPartOfTheQuery, ".");
            return fromPartOfTheQuery.substring(0, dbNameEndPos);
        });
    }

    private static boolean isInSingleLineComment(char currentChar, char previousChar, boolean isCurrentSubstringBetweenQuotes, boolean isInSingleLineComment) {
        if (!isCurrentSubstringBetweenQuotes && previousChar == '-' && currentChar == '-') {
            return true;
        }
        if (currentChar == '\n') {
            return false;
        }
        return isInSingleLineComment;
    }

    private static Optional<Pair<String, String>> extractPropertyPair(String cleanStatement, String sql) {
        String setQuery = RegExUtils.removeFirst(cleanStatement, SET_WITH_SPACE_REGEX);
        String[] values = StringUtils.split(setQuery, "=");
        if (values.length == 2) {
            String value = StringUtils.removeEnd(values[1], ";").trim();
            if (StringUtils.isNumeric(value)) {
                return Optional.of(Pair.of(values[0].trim(), value.trim()));
            }
            return Optional.of(Pair.of(values[0].trim(), StringUtils.removeEnd(StringUtils.removeStart(value, "'"), "'")));
        }
        throw new IllegalArgumentException("Cannot parse the additional properties provided in the statement: " + sql);
    }

    @Generated
    private StatementUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

