/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.NonQueryRawStatement;
import com.databend.jdbc.ParamMarker;
import com.databend.jdbc.QueryRawStatement;
import com.databend.jdbc.SetParamRawStatement;
import com.databend.jdbc.StatementType;
import com.databend.jdbc.StatementUtil;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RawStatement {
    private final String sql;
    private final String cleanSql;
    private final List<ParamMarker> paramMarkers;

    protected RawStatement(String sql, String cleanSql, List<ParamMarker> paramPositions) {
        this.sql = sql;
        this.cleanSql = cleanSql;
        this.paramMarkers = paramPositions;
    }

    public static RawStatement of(String sql, List<ParamMarker> paramPositions, String cleanSql) {
        Optional<Pair<String, String>> additionalProperties = StatementUtil.extractParamFromSetStatement(cleanSql, sql);
        if (additionalProperties.isPresent()) {
            return new SetParamRawStatement(sql, cleanSql, paramPositions, additionalProperties.get());
        }
        if (StatementUtil.isQuery(cleanSql)) {
            return new QueryRawStatement(sql, cleanSql, paramPositions);
        }
        return new NonQueryRawStatement(sql, cleanSql, paramPositions);
    }

    public String toString() {
        return "RawSqlStatement{sql='" + this.sql + '\'' + ", cleanSql='" + this.cleanSql + '\'' + ", paramMarkers=" + StringUtils.join(this.paramMarkers, "|") + '}';
    }

    public List<ParamMarker> getParamMarkers() {
        return this.paramMarkers;
    }

    public String getSql() {
        return this.sql;
    }

    public String getCleanSql() {
        return this.cleanSql;
    }

    public abstract StatementType getStatementType();

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawStatement)) {
            return false;
        }
        RawStatement other = (RawStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$cleanSql = this.getCleanSql();
        String other$cleanSql = other.getCleanSql();
        if (this$cleanSql == null ? other$cleanSql != null : !this$cleanSql.equals(other$cleanSql)) {
            return false;
        }
        List<ParamMarker> this$paramMarkers = this.getParamMarkers();
        List<ParamMarker> other$paramMarkers = other.getParamMarkers();
        return !(this$paramMarkers == null ? other$paramMarkers != null : !((Object)this$paramMarkers).equals(other$paramMarkers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawStatement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $cleanSql = this.getCleanSql();
        result = result * 59 + ($cleanSql == null ? 43 : $cleanSql.hashCode());
        List<ParamMarker> $paramMarkers = this.getParamMarkers();
        result = result * 59 + ($paramMarkers == null ? 43 : ((Object)$paramMarkers).hashCode());
        return result;
    }
}

