/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.DatabendDataType;
import com.databend.jdbc.com.fasterxml.jackson.annotation.JsonCreator;
import com.google.shaded.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DatabendRawType {
    private final String type;
    private final boolean isNullable;
    private final DatabendDataType dataType;
    private Integer columnSize = null;
    private Integer decimalDigits = null;
    private List<DatabendRawType> subType = null;

    @JsonCreator
    public DatabendRawType(String type) {
        if (DatabendRawType.startsWithIgnoreCase(type, "Nullable")) {
            this.isNullable = true;
            this.type = type.substring(9, type.length() - 1);
        } else {
            this.isNullable = false;
            this.type = type;
        }
        this.dataType = DatabendDataType.getByTypeName(this.type);
        if (this.dataType == DatabendDataType.DECIMAL) {
            if (this.type.contains(",")) {
                this.columnSize = Integer.valueOf(this.type.substring(this.type.indexOf("(") + 1, this.type.indexOf(",")).trim());
                this.decimalDigits = Integer.valueOf(this.type.substring(this.type.indexOf(",") + 1, this.type.indexOf(")")).trim());
            } else {
                this.columnSize = this.dataType.getLength();
                this.decimalDigits = 0;
            }
        } else if (this.dataType == DatabendDataType.ARRAY) {
            String subTypeName = this.type.substring(6, this.type.length() - 1);
            this.subType = Collections.singletonList(new DatabendRawType(subTypeName));
        } else if (this.dataType == DatabendDataType.TUPLE) {
            String subTypes = this.type.substring(6, this.type.length() - 1);
            this.subType = this.splitByComma(subTypes).stream().map(DatabendRawType::new).collect(Collectors.toList());
            this.columnSize = this.subType.size();
        } else if (this.dataType == DatabendDataType.MAP) {
            String subTypes = this.type.substring(4, this.type.length() - 1);
            this.subType = this.splitByComma(subTypes).stream().map(DatabendRawType::new).collect(Collectors.toList());
            this.columnSize = this.subType.size();
        }
        if (this.columnSize == null) {
            this.columnSize = this.dataType.getLength();
        }
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private List<String> splitByComma(String types) {
        ArrayList<String> splitTypes = new ArrayList<String>();
        StringBuilder splitType = new StringBuilder();
        int commaTotal = 0;
        int size = types.length();
        for (int i = 0; i < size; ++i) {
            char word = types.charAt(i);
            if ('(' == word) {
                ++commaTotal;
            } else if (')' == word) {
                --commaTotal;
            }
            if (',' == word && commaTotal == 0) {
                splitTypes.add(splitType.toString().trim());
                splitType = new StringBuilder();
                continue;
            }
            splitType.append(word);
        }
        if (splitType.length() > 0) {
            splitTypes.add(splitType.toString());
        }
        return splitTypes;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public DatabendDataType getDataType() {
        return this.dataType;
    }

    public Integer getColumnSize() {
        return this.columnSize;
    }

    public Integer getDecimalDigits() {
        return this.decimalDigits;
    }

    public List<DatabendRawType> getSubType() {
        return this.subType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("subType", this.subType).add("isNullable", this.isNullable).add("dataType", (Object)this.dataType).add("columnSize", this.columnSize).add("decimalDigits", this.decimalDigits).toString();
    }
}

