/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

public abstract class ColumnTypeHandlerBase
implements ColumnTypeHandler {
    protected boolean isNullable;

    public ColumnTypeHandlerBase(boolean isNullable) {
        this.isNullable = isNullable;
    }

    protected boolean isNull(String value) {
        return value == null || "NULL".equals(value);
    }

    private boolean checkNull(String value) {
        if (this.isNull(value)) {
            if (this.isNullable) {
                return true;
            }
            throw new IllegalArgumentException("type " + this.getClass().getName() + " is not nullable, but got " + value);
        }
        return false;
    }

    @Override
    public Object parseString(String value) {
        if (this.checkNull(value)) {
            return null;
        }
        return this.parseStringNotNull(value);
    }

    @Override
    public Object parseValue(Object value) {
        return this.parseString((String)value);
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    abstract Object parseStringNotNull(String var1);
}

