/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.StageAttachment;
import com.databend.jdbc.DatabendConnection;
import com.databend.jdbc.DatabendStatement;
import com.databend.jdbc.ObjectCasts;
import com.databend.jdbc.cloud.DatabendCopyParams;
import com.databend.jdbc.cloud.DatabendStage;
import com.databend.jdbc.parser.BatchInsertUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DatabendPreparedStatement
extends DatabendStatement
implements PreparedStatement {
    private static final Logger logger = Logger.getLogger(DatabendPreparedStatement.class.getPackage().getName());
    static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date();
    static final DateTimeFormatter TIME_FORMATTER = DateTimeFormat.forPattern("HH:mm:ss.SSS");
    static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final java.time.format.DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(java.time.format.DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(java.time.format.DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    private static final java.time.format.DateTimeFormatter OFFSET_TIME_FORMATTER = new DateTimeFormatterBuilder().append(java.time.format.DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:mm", "+00:00").toFormatter();
    private final String originalSql;
    private final List<String[]> batchValues;
    private final Optional<BatchInsertUtils> batchInsertUtils;
    private final String statementName;
    private int batchSize = 0;

    DatabendPreparedStatement(DatabendConnection connection, Consumer<DatabendStatement> onClose, String statementName, String sql) {
        super(connection, onClose);
        this.statementName = Objects.requireNonNull(statementName, "statementName is null");
        this.originalSql = Objects.requireNonNull(sql, "sql is null");
        this.batchValues = new ArrayList<String[]>();
        this.batchInsertUtils = BatchInsertUtils.tryParseInsertSql(sql);
    }

    private static String formatBooleanLiteral(boolean x) {
        return Boolean.toString(x);
    }

    private static String formatByteLiteral(byte x) {
        return Byte.toString(x);
    }

    private static String formatShortLiteral(short x) {
        return Short.toString(x);
    }

    private static String formatIntLiteral(int x) {
        return Integer.toString(x);
    }

    private static String formatLongLiteral(long x) {
        return Long.toString(x);
    }

    private static String formatFloatLiteral(float x) {
        return Float.toString(x);
    }

    private static String formatDoubleLiteral(double x) {
        return Double.toString(x);
    }

    private static String formatBigDecimalLiteral(BigDecimal x) {
        if (x == null) {
            return "null";
        }
        return x.toString();
    }

    private static String formatBytesLiteral(byte[] x) {
        return new String(x, StandardCharsets.UTF_8);
    }

    static IllegalArgumentException invalidConversion(Object x, String toType) {
        return new IllegalArgumentException(String.format("Cannot convert instance of %s to %s", x.getClass().getName(), toType));
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }

    private DatabendCopyParams uploadBatchesForCopyInto() throws SQLException {
        if (this.batchValues == null || this.batchValues.size() == 0) {
            return null;
        }
        File saved = this.batchInsertUtils.get().saveBatchToCSV(this.batchValues);
        try {
            DatabendCopyParams databendCopyParams;
            FileInputStream fis = new FileInputStream(saved);
            try {
                DatabendCopyParams databendCopyParams2;
                DatabendConnection c = (DatabendConnection)this.getConnection();
                String uuid = UUID.randomUUID().toString();
                String stagePrefix = String.format("%s/%s/%s/%s/%s/%s/%s/", LocalDateTime.now().getYear(), LocalDateTime.now().getMonthValue(), LocalDateTime.now().getDayOfMonth(), LocalDateTime.now().getHour(), LocalDateTime.now().getMinute(), LocalDateTime.now().getSecond(), uuid);
                String fileName = saved.getName();
                c.uploadStream(null, stagePrefix, fis, fileName, saved.length(), false);
                String stageName = "~";
                HashMap<String, String> copyOptions = new HashMap<String, String>();
                copyOptions.put("PURGE", String.valueOf(c.copyPurge()));
                DatabendStage databendStage = DatabendStage.builder().stageName(stageName).path(stagePrefix).build();
                databendCopyParams = databendCopyParams2 = DatabendCopyParams.builder().setPattern(fileName).setCopyOptions(copyOptions).setDatabaseTableName(this.batchInsertUtils.get().getDatabaseTableName()).setDatabendStage(databendStage).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
            fis.close();
            return databendCopyParams;
        }
        finally {
            try {
                if (saved != null) {
                    saved.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    private StageAttachment uploadBatches() throws SQLException {
        if (this.batchValues == null || this.batchValues.size() == 0) {
            return null;
        }
        File saved = this.batchInsertUtils.get().saveBatchToCSV(this.batchValues);
        try {
            StageAttachment stageAttachment;
            FileInputStream fis = new FileInputStream(saved);
            try {
                StageAttachment attachment;
                DatabendConnection c = (DatabendConnection)this.getConnection();
                String uuid = UUID.randomUUID().toString();
                String stagePrefix = String.format("%s/%s/%s/%s/%s/%s/%s/", LocalDateTime.now().getYear(), LocalDateTime.now().getMonthValue(), LocalDateTime.now().getDayOfMonth(), LocalDateTime.now().getHour(), LocalDateTime.now().getMinute(), LocalDateTime.now().getSecond(), uuid);
                String fileName = saved.getName();
                c.uploadStream(null, stagePrefix, fis, fileName, saved.length(), false);
                String stagePath = "@~/" + stagePrefix + fileName;
                stageAttachment = attachment = new StageAttachment.Builder().setLocation(stagePath).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
            fis.close();
            return stageAttachment;
        }
        finally {
            try {
                if (saved != null) {
                    saved.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean dropStageAttachment(StageAttachment attachment) {
        if (attachment == null) {
            return true;
        }
        String sql = String.format("REMOVE %s", attachment.getLocation());
        try {
            this.execute(sql);
            return true;
        }
        catch (SQLException e) {
            return e.getErrorCode() == 1003;
        }
    }

    public int[] executeBatchByAttachment() throws SQLException {
        int[] batchUpdateCounts = new int[this.batchValues.size()];
        if (!this.batchInsertUtils.isPresent() || this.batchValues == null || this.batchValues.isEmpty()) {
            super.execute(this.originalSql);
            return batchUpdateCounts;
        }
        StageAttachment attachment = this.uploadBatches();
        ResultSet r = null;
        if (attachment == null) {
            logger.fine("use normal execute instead of batch insert");
            super.execute(this.batchInsertUtils.get().getSql());
            return batchUpdateCounts;
        }
        try {
            logger.fine(String.format("use batch insert instead of normal insert, attachment: %s, sql: %s", attachment, this.batchInsertUtils.get().getSql()));
            super.internalExecute(this.batchInsertUtils.get().getSql(), attachment);
            r = this.getResultSet();
            while (r.next()) {
            }
            Arrays.fill(batchUpdateCounts, 1);
            int[] nArray = batchUpdateCounts;
            return nArray;
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
        finally {
            this.dropStageAttachment(attachment);
        }
    }

    public int[] executeBatchByCopyInto() throws SQLException {
        int[] batchUpdateCounts = new int[this.batchValues.size()];
        if (!this.batchInsertUtils.isPresent() || this.batchValues == null || this.batchValues.isEmpty()) {
            super.execute(this.originalSql);
            return batchUpdateCounts;
        }
        DatabendCopyParams databendCopyParams = this.uploadBatchesForCopyInto();
        ResultSet r = null;
        if (databendCopyParams == null) {
            logger.fine("use normal execute instead of batch insert");
            super.execute(this.batchInsertUtils.get().getSql());
            return batchUpdateCounts;
        }
        try {
            String sql = DatabendConnection.getCopyIntoSql(null, databendCopyParams);
            logger.fine(String.format("use copy into instead of normal insert, copy into SQL: %s", sql));
            super.internalExecute(sql, null);
            r = this.getResultSet();
            while (r.next()) {
            }
            Arrays.fill(batchUpdateCounts, 1);
            return batchUpdateCounts;
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.executeBatchByCopyInto();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeBatch();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return 0;
    }

    @Override
    public void setNull(int i, int i1) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, null));
    }

    @Override
    public void setBoolean(int i, boolean b) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatBooleanLiteral(b)));
    }

    @Override
    public void setByte(int i, byte b) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatByteLiteral(b)));
    }

    @Override
    public void setShort(int i, short i1) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatShortLiteral(i1)));
    }

    @Override
    public void setInt(int i, int i1) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatIntLiteral(i1)));
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatLongLiteral(l)));
    }

    @Override
    public void setFloat(int i, float v) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatFloatLiteral(v)));
    }

    @Override
    public void setDouble(int i, double v) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatDoubleLiteral(v)));
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatBigDecimalLiteral(bigDecimal)));
    }

    @Override
    public void setString(int i, String s) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, s));
    }

    @Override
    public void setBytes(int i, byte[] bytes) throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, DatabendPreparedStatement.formatBytesLiteral(bytes)));
    }

    @Override
    public void setDate(int i, Date date) throws SQLException {
        this.checkOpen();
        if (date == null) {
            this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, null));
        } else {
            this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, this.toDateLiteral(date)));
        }
    }

    @Override
    public void setTime(int i, Time time) throws SQLException {
        this.checkOpen();
        if (time == null) {
            this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, null));
        } else {
            this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, this.toTimeLiteral(time)));
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        if (timestamp == null) {
            this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, null));
        } else {
            this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(i, this.toTimestampLiteral(timestamp)));
        }
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream2, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream not supported");
    }

    @Override
    public void setUnicodeStream(int i, InputStream inputStream2, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("setUnicodeStream not supported");
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream2, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream not supported");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.batchInsertUtils.ifPresent(BatchInsertUtils::clean);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.batchInsertUtils.ifPresent(insertUtils -> insertUtils.setPlaceHolderValue(parameterIndex, null));
        }
        switch (targetSqlType) {
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, ObjectCasts.castToBoolean(x, targetSqlType));
                return;
            }
            case -6: {
                this.setByte(parameterIndex, ObjectCasts.castToByte(x, targetSqlType));
                return;
            }
            case 5: {
                this.setShort(parameterIndex, ObjectCasts.castToShort(x, targetSqlType));
                return;
            }
            case 4: {
                this.setInt(parameterIndex, ObjectCasts.castToInt(x, targetSqlType));
                return;
            }
            case -5: {
                this.setLong(parameterIndex, ObjectCasts.castToLong(x, targetSqlType));
                return;
            }
            case 6: 
            case 7: {
                this.setFloat(parameterIndex, ObjectCasts.castToFloat(x, targetSqlType));
                return;
            }
            case 8: {
                this.setDouble(parameterIndex, ObjectCasts.castToDouble(x, targetSqlType));
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, ObjectCasts.castToBigDecimal(x, targetSqlType));
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, ObjectCasts.castToBinary(x, targetSqlType));
                return;
            }
            case 91: {
                this.setString(parameterIndex, this.toDateLiteral(x));
                return;
            }
            case 92: {
                this.setString(parameterIndex, this.toTimeLiteral(x));
                return;
            }
            case 2013: {
                this.setString(parameterIndex, this.toTimeWithTimeZoneLiteral(x));
                return;
            }
            case 93: {
                this.setString(parameterIndex, this.toTimestampLiteral(x));
                return;
            }
            case 2014: {
                this.setString(parameterIndex, this.toTimestampWithTimeZoneLiteral(x));
                return;
            }
        }
        throw new SQLException("Unsupported target SQL type: " + targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof LocalDate) {
            this.setString(parameterIndex, this.toDateLiteral(x));
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof OffsetTime) {
            this.setString(parameterIndex, this.toTimeWithTimeZoneLiteral(x));
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new SQLException("Unsupported object type: " + x.getClass().getName());
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        if (this.batchInsertUtils.isPresent()) {
            String[] val = this.batchInsertUtils.get().getValues();
            this.batchValues.add(val);
            this.batchInsertUtils.get().clean();
            ++this.batchSize;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        this.batchValues.clear();
        this.batchSize = 0;
        this.batchInsertUtils.ifPresent(BatchInsertUtils::clean);
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setRef(int i, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setRef");
    }

    @Override
    public void setBlob(int i, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setBlob");
    }

    @Override
    public void setClob(int i, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setClob");
    }

    @Override
    public void setArray(int i, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setArray");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int i, Date date, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setDate");
    }

    @Override
    public void setTime(int i, Time time, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setTime");
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setTimestamp");
    }

    @Override
    public void setNull(int i, int i1, String s) throws SQLException {
        this.setNull(i, i1);
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setURL");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int i, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setRowId");
    }

    @Override
    public void setNString(int i, String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setNString");
    }

    @Override
    public void setNCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setNCharacterStream");
    }

    @Override
    public void setNClob(int i, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setNClob");
    }

    @Override
    public void setClob(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setClob");
    }

    @Override
    public void setBlob(int i, InputStream inputStream2, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setBlob");
    }

    @Override
    public void setNClob(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setNClob");
    }

    @Override
    public void setSQLXML(int i, SQLXML sqlxml) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setSQLXML");
    }

    @Override
    public void setObject(int i, Object o, int i1, int i2) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setObject");
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream2, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream2, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void setCharacterStream(int i, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setAsciiStream(int i, InputStream inputStream2) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setBinaryStream(int i, InputStream inputStream2) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void setCharacterStream(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setNCharacterStream");
    }

    @Override
    public void setClob(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setClob");
    }

    @Override
    public void setBlob(int i, InputStream inputStream2) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setBlob");
    }

    @Override
    public void setNClob(int i, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement", "setNClob");
    }

    private String toDateLiteral(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value is null");
        if (value instanceof java.util.Date) {
            return DATE_FORMATTER.print(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return java.time.format.DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return java.time.format.DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDateTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw DatabendPreparedStatement.invalidConversion(value, "date");
    }

    private String toTimeLiteral(Object value) throws IllegalArgumentException {
        if (value instanceof java.util.Date) {
            return TIME_FORMATTER.print(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalTime) {
            return java.time.format.DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return java.time.format.DateTimeFormatter.ISO_LOCAL_TIME.format((LocalDateTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw DatabendPreparedStatement.invalidConversion(value, "time");
    }

    private String toTimestampLiteral(Object value) throws IllegalArgumentException {
        if (value instanceof java.util.Date) {
            return TIMESTAMP_FORMATTER.print(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDateTime) {
            return LOCAL_DATE_TIME_FORMATTER.format((LocalDateTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw DatabendPreparedStatement.invalidConversion(value, "timestamp");
    }

    private String toTimestampWithTimeZoneLiteral(Object value) throws SQLException {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof OffsetDateTime) {
            return OFFSET_TIME_FORMATTER.format((OffsetDateTime)value);
        }
        throw DatabendPreparedStatement.invalidConversion(value, "timestamp with time zone");
    }

    private String toTimeWithTimeZoneLiteral(Object value) throws SQLException {
        if (value instanceof OffsetTime) {
            return OFFSET_TIME_FORMATTER.format((OffsetTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw DatabendPreparedStatement.invalidConversion(value, "time with time zone");
    }
}

