/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

class UInt32Handler
implements ColumnTypeHandler {
    private boolean isNullable;

    public UInt32Handler() {
        this.isNullable = false;
    }

    public UInt32Handler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return this.parseNonNullValue(value);
    }

    private Long parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    private long parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("UInt32 type is not nullable");
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return 0L;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

