/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

class Int16Handler
implements ColumnTypeHandler {
    private boolean isNullable;

    public Int16Handler() {
        this.isNullable = false;
    }

    public Int16Handler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return this.parseNonNullValue(value);
    }

    private Short parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return null;
    }

    private short parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("Int16 type is not nullable");
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return 0;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

