/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class OkHttpUtils {
    private OkHttpUtils() {
    }

    public static Interceptor userAgentInterceptor(String userAgent) {
        return chain -> chain.proceed(chain.request().newBuilder().header("User-Agent", userAgent).build());
    }

    public static Interceptor basicAuthInterceptor(String username, String password) {
        return chain -> chain.proceed(chain.request().newBuilder().header("Authorization", Credentials.basic(username, password)).build());
    }

    public static Interceptor tokenAuth(String accessToken) {
        Objects.requireNonNull(accessToken, "accessToken is null");
        Preconditions.checkArgument(CharMatcher.inRange('!', '~').matchesAllOf(accessToken));
        return chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + accessToken).build());
    }

    public static void setupTimeouts(OkHttpClient.Builder clientBuilder, int timeout2, TimeUnit unit) {
        clientBuilder.connectTimeout(timeout2, unit).readTimeout(timeout2, unit).writeTimeout(timeout2, unit);
    }

    public static void setupInsecureSsl(OkHttpClient.Builder clientBuilder) {
        try {
            X509TrustManager trustAllCerts = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    throw new UnsupportedOperationException("checkClientTrusted should not be called");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustAllCerts}, new SecureRandom());
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustAllCerts);
            clientBuilder.hostnameVerifier((hostname, session) -> true);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Error setting up SSL: " + e.getMessage(), e);
        }
    }
}

