/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.a.a.m;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.plugin.fldr.ColumnInfo;
import dm.jdbc.plugin.fldr.FldrHashCode;
import dm.jdbc.plugin.fldr.HorizontalTableInfo;
import dm.jdbc.util.StringUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class TableInfo {
    private String tableName;
    public boolean dpcFlag = false;
    private List<ColumnInfo> columnInfos;
    private Map<String, Short> nameIdMap;
    private HorizontalTableInfo hTableHead;
    public HashMap<String, Integer> subTableNameIdMap;
    public Map<String, List<Object[]>> hTableNameData = new HashMap<String, List<Object[]>>();
    public int autoIncrementColId;
    public long seed;
    public long currentValue;
    public long increment;
    public boolean containLob = false;
    public boolean containDecimal = false;
    private int dBTimeZone = 1000;
    private int localTimeZone = 480;
    private DmdbConnection conn = null;

    public TableInfo() {
    }

    public TableInfo(List<ColumnInfo> columnInfos, Map<String, Short> nameIdMap, HorizontalTableInfo hTableHead, boolean containLob) {
        this.columnInfos = columnInfos;
        this.nameIdMap = nameIdMap;
        this.hTableHead = hTableHead;
        this.containLob = containLob;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }

    public Map<String, Short> getNameIdMap() {
        return this.nameIdMap;
    }

    public void setNameIdMap(Map<String, Short> nameIdMap) {
        this.nameIdMap = nameIdMap;
    }

    public HorizontalTableInfo gethTableHead() {
        return this.hTableHead;
    }

    public void sethTableHead(HorizontalTableInfo hTableHead) {
        this.hTableHead = hTableHead;
    }

    public Short getColumnIdByName(String columnName) throws SQLException {
        Short columnId;
        if (columnName == null || columnName.length() == 0) {
            DBError.ECJDBC_COLNAMES_NULL.throwz(new Object[0]);
        }
        columnName = columnName.toUpperCase();
        if (this.nameIdMap == null || this.nameIdMap.size() == 0) {
            DBError.ECJDBC_INVALID_COLUMN_NAME.throwz(new Object[0]);
        }
        if ((columnId = this.nameIdMap.get(columnName)) == null) {
            DBError.ECJDBC_COLINDEXES_NULL.throwz(new Object[0]);
        }
        return columnId;
    }

    public int getDBTimeZone() {
        return this.dBTimeZone;
    }

    public void setDBTimeZone(int timeZone) {
        this.dBTimeZone = timeZone;
    }

    public int getLocalTimeZone() {
        return this.localTimeZone;
    }

    public void setLocalTimeZone(int localTimeZone) {
        this.localTimeZone = localTimeZone;
    }

    public DmdbConnection getConn() {
        return this.conn;
    }

    public void setConn(DmdbConnection conn) {
        this.conn = conn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Map<String, List<Object[]>> getHTabPartition(Object[] singleRow) throws SQLException {
        if (this.hTableHead == null) {
            return this.hTableNameData;
        }
        HorizontalTableInfo head = this.hTableHead;
        while (head.getChildren() != null && head.getChildren().size() > 0) {
            short[] partitionColIds = head.getPartitionColIds();
            short[] sqlTypes = head.getSqlType();
            int index = -1;
            int maxIndex = Integer.MIN_VALUE;
            int hashSize = 0;
            if (head.getTableType() == 8) {
                hashSize = FldrHashCode.tableSizeFor(head.getSubTableIds().length);
            }
            int i2 = 0;
            while (i2 < sqlTypes.length) {
                short sqlType = sqlTypes[i2];
                if (head.getTableType() == 8) {
                    long hashValue = FldrHashCode.hc_get_fold_fun(sqlType, hashSize, singleRow[partitionColIds[i2]], this.conn);
                    index = FldrHashCode.compareNumHash(hashSize, head.getSubTableIds().length, hashValue);
                } else {
                    switch (sqlType) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: {
                            index = this.compareNum(head, i2, singleRow[partitionColIds[i2]]);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 12: 
                        case 17: 
                        case 18: 
                        case 19: {
                            index = this.compareVarchar(head, i2, singleRow[partitionColIds[i2]]);
                            break;
                        }
                        case 0: {
                            index = this.compareChar(head, i2, singleRow[partitionColIds[i2]]);
                            break;
                        }
                        case 9: {
                            index = this.compareDecimal(head, i2, singleRow[partitionColIds[i2]]);
                            break;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 22: 
                        case 23: 
                        case 26: 
                        case 27: {
                            index = this.compareDate(head, i2, singleRow[partitionColIds[i2]], sqlType);
                            break;
                        }
                        default: {
                            DBError.ECJDBC_INVALID_SQL_TYPE.throwz(String.format("\u8be5\u7c7b\u578b%s\u4e0d\u652f\u6301\u5206\u533a\u6bd4\u8f83", sqlType));
                        }
                    }
                }
                maxIndex = index > maxIndex ? index : maxIndex;
                ++i2;
            }
            if (maxIndex < 0) continue;
            head = head.getChildren().get(maxIndex);
        }
        List<Object[]> data = this.hTableNameData.get(head.getTableName());
        if (data == null) {
            data = new ArrayList<Object[]>();
            data.add(singleRow);
            this.hTableNameData.put(head.getTableName(), data);
        } else {
            data.add(singleRow);
        }
        return this.hTableNameData;
    }

    public void clearData() {
        this.hTableNameData = new HashMap<String, List<Object[]>>();
    }

    private int compareNum(HorizontalTableInfo node, int index, Object value) throws SQLException {
        if (value == null) {
            if (node.getTableType() == 11) {
                return node.getDefaultPartition();
            }
            return 0;
        }
        Object[] targets = node.getBoundaries().get(index);
        int[] includeFlag = node.getIncludeFlag();
        int result = -1;
        try {
            if (value instanceof Byte) {
                byte val = (Byte)value;
                result = Arrays.binarySearch(targets, (Object)val);
            } else if (value instanceof Short) {
                short val = (Short)value;
                result = Arrays.binarySearch(targets, (Object)val);
            } else {
                result = Arrays.binarySearch(targets, value);
            }
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (result < 0) {
            if (node.getTableType() == 11) {
                return node.getDefaultPartition();
            }
            result = -1 - result;
        }
        if (value.equals(targets[result]) && includeFlag[result] == 0 && ++result >= targets.length) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        return result;
    }

    private int compareChar(HorizontalTableInfo node, int index, Object value) throws SQLException {
        try {
            String str = StringUtil.rightTrim(value.toString());
            return this.compareVarchar(node, index, str);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
            return -1;
        }
    }

    private int compareVarchar(HorizontalTableInfo node, int index, Object value) throws SQLException {
        try {
            if (value == null) {
                value = "";
            }
            Object[] targets = node.getBoundaries().get(index);
            int[] includeFlag = node.getIncludeFlag();
            int result = -1;
            String res = (String)value;
            if (node.getTableType() == 11) {
                int i2 = 0;
                while (i2 < targets.length) {
                    String str = (String)targets[i2];
                    if (str.equals("") || res.compareTo(str) == 0) {
                        result = i2;
                        break;
                    }
                    ++i2;
                }
                if (result == -1) {
                    DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
                }
            } else {
                int i3 = 0;
                while (i3 < targets.length) {
                    String str = (String)targets[i3];
                    if (str.equals("") || res.compareTo(str) <= 0) {
                        result = i3;
                        break;
                    }
                    ++i3;
                }
                if (value.equals(targets[result]) && includeFlag[result] == 0 && ++result >= targets.length) {
                    DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
                }
            }
            return result;
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
            return -1;
        }
    }

    private int compareDecimal(HorizontalTableInfo node, int index, Object value) throws SQLException {
        BigDecimal dec2;
        BigDecimal dec1;
        if (value == null) {
            if (node.getTableType() == 11) {
                return node.getDefaultPartition();
            }
            return 0;
        }
        Object[] targets = node.getBoundaries().get(index);
        int[] includeFlag = node.getIncludeFlag();
        int result = -1;
        try {
            result = Arrays.binarySearch(targets, value);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (result < 0) {
            if (node.getTableType() == 11) {
                return node.getDefaultPartition();
            }
            result = -1 - result;
        }
        if ((dec1 = (BigDecimal)value).compareTo(dec2 = (BigDecimal)targets[result]) == 0 && includeFlag[result] == 0 && ++result >= targets.length) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        return result;
    }

    private int compareDate(HorizontalTableInfo node, int index, Object value, int sqlType) throws SQLException {
        long compareVal;
        if (value == null) {
            if (node.getTableType() == 11) {
                return node.getDefaultPartition();
            }
            return 0;
        }
        Object[] targets = node.getBoundaries().get(index);
        long[] vals = new long[targets.length];
        int i2 = 0;
        while (i2 < targets.length) {
            vals[i2] = (Long)targets[i2];
            ++i2;
        }
        if (sqlType == 15 || sqlType == 22) {
            compareVal = this.timeHelper((Date)value);
        } else {
            Calendar instance = Calendar.getInstance();
            instance.setTime((Date)value);
            int msc = value instanceof Timestamp ? ((Timestamp)value).getNanos() / 1000 : instance.get(14);
            compareVal = m.a(instance.get(1), instance.get(2) + 1, instance.get(5), instance.get(11), instance.get(12), instance.get(13), msc);
        }
        int[] includeFlag = node.getIncludeFlag();
        int result = -1;
        try {
            result = Arrays.binarySearch(vals, compareVal);
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        if (result < 0) {
            if (node.getTableType() == 11) {
                return node.getDefaultPartition();
            }
            result = -1 - result;
        }
        if (compareVal == vals[result] && includeFlag[result] == 0 && ++result >= targets.length) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        return result;
    }

    private long timeHelper(Date date) {
        Calendar instance = Calendar.getInstance(TimeZone.getTimeZone("GMT+8"));
        instance.setTime(date);
        return (long)instance.get(11) * 3600000L + (long)instance.get(12) * 60000L + (long)instance.get(13) * 1000L + (long)instance.get(14);
    }
}

