package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseAuthenticationRespDTO;
import lombok.Data;

/**
 * Description: 自然人OCR识别响应DTO
 * <br />
 * CreateDate 2022-02-15 17:57
 *
 * @author yuy336
 **/
@Data
public class OcrNpRespDTO extends BaseAuthenticationRespDTO {

    private static final long serialVersionUID = 1L;

    /**
     * 证件正反面 front 国徽面  back 人像面
     */
    private String side;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 身份证证件号
     */
    private String certNumber;

    /**
     * 性别（男/女）
     */
    private String gender;

    /**
     * 住址
     */
    private String address;

    /**
     * 生日，格式为YYYY-MM-DD
     */
    private String birthday;

    /**
     * 民族（汉字）
     */
    private String race;

    /**
     * 证件人像照片（入参face_cut=1时处理并返回）
     */
    private String facePhoto;

    /**
     * 签发机关
     */
    private String issued;

    /**
     * 有效日期
     */
    private String validDate;
}
