package com.cusc.nirvana.user.rnr.base.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 文件上传记录
 * </p>
 */
@Data
@ApiModel(value="FileRecord对象", description="文件上传记录")
public class FileRecordDTO implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "文件标识id")
    private String uuid;

    @ApiModelProperty(value = "文件原始名称")
    private String fileName;

    @ApiModelProperty(value = "存储路径")
    private String path;

    @ApiModelProperty(value = "文件流md5")
    private String md5;

    @ApiModelProperty(value = "文件存储类型：private/public")
    private String useLimit;

    @ApiModelProperty(value = "对象存储文件公网url")
    private String accessUrl;

    @ApiModelProperty(value = "文件大小（KB）")
    private Double fileSize;

    @ApiModelProperty(value = "文件状态：1上传成功，0已删除，2待合并")
    private Integer status;

    @ApiModelProperty(value = "视频编码格式")
    private String videoProtocal;

    @ApiModelProperty(value = "上传时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "上传人")
    private String creator;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "修改人")
    private String updater;

}
