package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseAuthenticationReqDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * Description: 自然人身份信息核查请求DTO（校验姓名、身份证、照片的有效性）
 * <br />
 * CreateDate 2022-02-23 17:00:59
 *
 * @author yuyi
 **/
@Data
public class CertCheckReqDTO extends BaseAuthenticationReqDTO {

	/**
	 * 姓名
	 */
	@NotBlank(message = "姓名不能为空")
	private String fullName;

	/**
	 * 证件号
	 */
	@NotBlank(message = "证件号不能为空")
	private String certNumber;
}
