package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseRnrPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 认证日志(AuthenticationLog)传输对象类
 *
 * @author yuy336
 * @since 2022-02-15 15:56:10
 */
@ApiModel(value = "认证日志", description = "认证日志")
@Data
public class BaseAuthenticationLogPageDTO extends BaseRnrPageDTO {

    private static final long serialVersionUID = -43766585995232656L;

    @ApiModelProperty(value = "数据库主键")
    private Long id;

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "认证方式编号")
    private String authWayNo;

    @ApiModelProperty(value = "业务uuid")
    private String bizUuid;

    @ApiModelProperty(value = "业务uuid")
    private String serialNumber;

    @ApiModelProperty(value = "链路id")
    private String traceId;

    @ApiModelProperty(value = "响应时间，毫秒")
    private Integer responseCost;

    @ApiModelProperty(value = "响应状态")
    private String responseStatus;

    @ApiModelProperty(value = "是否成功")
    private Integer isSuccess;

    @ApiModelProperty(value = "请求参数")
    private String parameter;

    @ApiModelProperty(value = "请求时间")
    private Date requestTime;

    @ApiModelProperty(value = "响应时间")
    private Date responseTime;

    @ApiModelProperty(value = "响应描述，请求失败时，描述错误原因")
    private String responseMsg;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    private String creator;
}

