package com.cusc.nirvana.user.rnr.base.constants;

/**
 * Description: ocr证件正反面枚举
 * <br />
 * CreateDate 2022-02-14 15:31:33
 *
 * @author yuyi
 **/
public enum OcrNpSideEnum {

    FRONT("front", "国徽面"),
    BACK("back", "人像面");

    private String code;
    private String name;

    OcrNpSideEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static OcrNpSideEnum getEnumByCode(String code) {
        for (OcrNpSideEnum sys : OcrNpSideEnum.values()) {
            if (sys.getCode().equals(code)) {
                return sys;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
