package com.cusc.nirvana.user.rnr.base.constants;

/**
 * Description: 是否枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum CommonYesOrNoEnum {

    NO(0, "不是"),
    YES(1, "是");

    private int code;
    private String name;

    CommonYesOrNoEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CommonYesOrNoEnum getEnumByCode(int code) {
        for (CommonYesOrNoEnum sys : CommonYesOrNoEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
