package com.cusc.nirvana.user.rnr.base.common;

import com.cusc.nirvana.common.result.BaseEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * <p>
 * rnr响应基类
 * </p>
 *
 * @author yuyi
 * @since 2021-10-21
 */
@Data
public class RnrResponse<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    static final Object EMPTY = new Object();

    @ApiModelProperty(value = "流水号")
    private String serialNumber;

    @ApiModelProperty(value = "返回信息")
    private String msg;

    @ApiModelProperty(value = "code码")
    private Integer code;

    @ApiModelProperty(value = "数据")
    private T data;

    @ApiModelProperty(value = "是否成功")
    private boolean success;

    protected RnrResponse() {
    }

    private RnrResponse(String msg, Integer code, T data, Boolean success) {
        this.msg = msg;
        this.code = code;
        this.data = data;
        this.success = success;
    }

    public RnrResponse(String msg, T data, Boolean success) {
        this.msg = msg;
        this.data = data;
        this.success = success;
    }

    public RnrResponse(String msg, Boolean success) {
        this.msg = msg;
        this.success = success;
    }

    public static RnrResponse createSuccess(String msg) {
        return createSuccess(msg, null);
    }

    public static RnrResponse createSuccess(Object data) {
        return createSuccess(BaseEnum.SUCCESS.getMsg(), data);
    }

    public static RnrResponse createSuccess(String msg, Object data) {
        return createSuccess(msg, BaseEnum.SUCCESS.getCode(), data);
    }

    public static RnrResponse createSuccess(String msg, Object data, String... args) {
        return createFormatMsg(msg, BaseEnum.SUCCESS.getCode(), data, true, args);
    }

    public static RnrResponse createSuccess(String msg, String... args) {
        return createFormatMsg(msg, BaseEnum.SUCCESS.getCode(), null, true, args);
    }

    public static RnrResponse createSuccess(String msg, Integer code, Object data) {
        return new RnrResponse<>(msg, code, data, true);
    }

    public static RnrResponse createSuccess() {
        return new RnrResponse<>(BaseEnum.SUCCESS.getMsg(), BaseEnum.SUCCESS.getCode(), null, true);
    }

    public static RnrResponse createError() {
        return new RnrResponse<>(BaseEnum.ERROR.getMsg(), BaseEnum.ERROR.getCode(), EMPTY, false);
    }

    public static RnrResponse createError(String msg) {
        return createFormatMsg(msg, BaseEnum.ERROR.getCode(), EMPTY, false);
    }

    public static RnrResponse createError(String msg, String... args) {
        return createFormatMsg(msg, BaseEnum.ERROR.getCode(), EMPTY, false, args);
    }

    public static RnrResponse createError(String msg, Object data, String... args) {
        return createFormatMsg(msg, BaseEnum.ERROR.getCode(), data, false, args);
    }

    public static RnrResponse createError(String msg, Object data) {
        return new RnrResponse<>(msg, BaseEnum.ERROR.getCode(), data, false);
    }

    public static RnrResponse createError(String msg, Integer code, Object data) {
        return new RnrResponse<>(msg, code, data, false);
    }

    public static RnrResponse createError(String msg, Integer code) {
        return createFormatMsg(msg, code, EMPTY, false);
    }

    /**
     * 格式化msg
     *
     * @param msg
     * @param code
     * @param data
     * @param success
     * @param args    格式化参数 eg：%s占位符
     * @return
     */
    private static RnrResponse createFormatMsg(String msg, Integer code, Object data, Boolean success, String... args) {
        return new RnrResponse<>(String.format(msg, args), code, data, success);
    }
}
