/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.base.common;

import com.cusc.nirvana.common.result.BaseEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

public class RnrResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Object EMPTY = new Object();
    @ApiModelProperty(value="\u6d41\u6c34\u53f7")
    private String serialNumber;
    @ApiModelProperty(value="\u8fd4\u56de\u4fe1\u606f")
    private String msg;
    @ApiModelProperty(value="code\u7801")
    private Integer code;
    @ApiModelProperty(value="\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u662f\u5426\u6210\u529f")
    private boolean success;

    protected RnrResponse() {
    }

    private RnrResponse(String msg, Integer code, T data, Boolean success) {
        this.msg = msg;
        this.code = code;
        this.data = data;
        this.success = success;
    }

    public RnrResponse(String msg, T data, Boolean success) {
        this.msg = msg;
        this.data = data;
        this.success = success;
    }

    public RnrResponse(String msg, Boolean success) {
        this.msg = msg;
        this.success = success;
    }

    public static RnrResponse createSuccess(String msg) {
        return RnrResponse.createSuccess(msg, null);
    }

    public static RnrResponse createSuccess(Object data) {
        return RnrResponse.createSuccess(BaseEnum.SUCCESS.getMsg(), data);
    }

    public static RnrResponse createSuccess(String msg, Object data) {
        return RnrResponse.createSuccess(msg, BaseEnum.SUCCESS.getCode(), data);
    }

    public static RnrResponse createSuccess(String msg, Object data, String ... args) {
        return RnrResponse.createFormatMsg(msg, BaseEnum.SUCCESS.getCode(), data, true, args);
    }

    public static RnrResponse createSuccess(String msg, String ... args) {
        return RnrResponse.createFormatMsg(msg, BaseEnum.SUCCESS.getCode(), null, true, args);
    }

    public static RnrResponse createSuccess(String msg, Integer code, Object data) {
        return new RnrResponse<Object>(msg, code, data, true);
    }

    public static RnrResponse createSuccess() {
        return new RnrResponse<Object>(BaseEnum.SUCCESS.getMsg(), BaseEnum.SUCCESS.getCode(), null, true);
    }

    public static RnrResponse createError() {
        return new RnrResponse<Object>(BaseEnum.ERROR.getMsg(), BaseEnum.ERROR.getCode(), EMPTY, false);
    }

    public static RnrResponse createError(String msg) {
        return RnrResponse.createFormatMsg(msg, BaseEnum.ERROR.getCode(), EMPTY, false, new String[0]);
    }

    public static RnrResponse createError(String msg, String ... args) {
        return RnrResponse.createFormatMsg(msg, BaseEnum.ERROR.getCode(), EMPTY, false, args);
    }

    public static RnrResponse createError(String msg, Object data, String ... args) {
        return RnrResponse.createFormatMsg(msg, BaseEnum.ERROR.getCode(), data, false, args);
    }

    public static RnrResponse createError(String msg, Object data) {
        return new RnrResponse<Object>(msg, BaseEnum.ERROR.getCode(), data, false);
    }

    public static RnrResponse createError(String msg, Integer code, Object data) {
        return new RnrResponse<Object>(msg, code, data, false);
    }

    public static RnrResponse createError(String msg, Integer code) {
        return RnrResponse.createFormatMsg(msg, code, EMPTY, false, new String[0]);
    }

    private static RnrResponse createFormatMsg(String msg, Integer code, Object data, Boolean success, String ... args) {
        return new RnrResponse<Object>(String.format(msg, args), code, data, success);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getMsg() {
        return this.msg;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RnrResponse)) {
            return false;
        }
        RnrResponse other = (RnrResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RnrResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "RnrResponse(serialNumber=" + this.getSerialNumber() + ", msg=" + this.getMsg() + ", code=" + this.getCode() + ", data=" + this.getData() + ", success=" + this.isSuccess() + ")";
    }
}

