package com.cusc.nirvana.user.rnr.base.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.base.common.RnrBaseLogOutputJsonSerializeFilter;
import com.cusc.nirvana.user.rnr.base.common.RnrResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * Description: resttemplate封装
 * <br />
 * CreateDate 2021-11-01 16:46
 *
 * @author yuyi
 **/
public class RnrBaseRestTemplateUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(RnrBaseRestTemplateUtils.class);


    /**
     * Description: post请求Response泛型
     * <br />
     * CreateDate 2021-11-01 16:53:25
     *
     * @author yuyi
     **/
    public static <T> Response<T> postForResponse(RestTemplate restTemplate, String url, Object request,
                                                  Class<T> cls, Object... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForResponse url: {},request: {}", url,
                JSON.toJSONString(request, new RnrBaseLogOutputJsonSerializeFilter()));
        ResponseEntity<String> entity =
                restTemplate.exchange(url, HttpMethod.POST, new HttpEntity<>(request), String.class, urlVariables);
        Response<T> result = JSON.parseObject(entity.getBody(), new TypeReference<Response<T>>(cls) {
        }.getType());
        LOGGER.info("postForResponse url: {},response: {},cost: {} ms", url,
                JSON.toJSONString(result, new RnrBaseLogOutputJsonSerializeFilter()),
                System.currentTimeMillis() - startTime);
        return result;
    }

    /**
     * Description: post请求Response<PageResult>泛型
     * <br />
     * CreateDate 2021-11-01 16:53:25
     *
     * @author yuyi
     **/
    public static <T> Response<PageResult<T>> postForResponsePageResult(RestTemplate restTemplate, String url,
                                                                        Object request,
                                                                        Class<T> cls, Object... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForResponsePageResult url: {},request: {}", url,
                JSON.toJSONString(request, new RnrBaseLogOutputJsonSerializeFilter()));
        ResponseEntity<String> entity =
                restTemplate.exchange(url, HttpMethod.POST, new HttpEntity<>(request), String.class, urlVariables);
        Response<PageResult<T>> result = JSON.parseObject(entity.getBody(),
                new TypeReference<Response<PageResult<T>>>(cls) {
                }.getType());
        LOGGER.info("postForResponsePageResult url: {},response: {},cost: {} ms", url,
                JSON.toJSONString(result, new RnrBaseLogOutputJsonSerializeFilter()),
                System.currentTimeMillis() - startTime);
        return result;
    }

    /**
     * Description: post请求Response<List>泛型
     * <br />
     * CreateDate 2021-11-01 16:53:25
     *
     * @author yuyi
     **/
    public static <T> Response<List<T>> postForResponseList(RestTemplate restTemplate, String url, Object request,
                                                            Class<T> cls, Object... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForResponseList url: {},request: {}", url,
                JSON.toJSONString(request, new RnrBaseLogOutputJsonSerializeFilter()));
        ResponseEntity<String> entity =
                restTemplate.exchange(url, HttpMethod.POST, new HttpEntity<>(request), String.class, urlVariables);
        Response<List<T>> result = JSON.parseObject(entity.getBody(), new TypeReference<Response<List<T>>>(cls) {
        }.getType());
        LOGGER.info("postForResponseList url: {},response: {},cost: {} ms", url,
                JSON.toJSONString(result, new RnrBaseLogOutputJsonSerializeFilter()),
                System.currentTimeMillis() - startTime);
        return result;
    }


    public static <T> RnrResponse<T> postForRnrResponse(RestTemplate restTemplate, String url, Object request,
                                                        Class<T> cls, Object... urlVariables) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("postForRnrResponse url: {},request: {}", url,
                JSON.toJSONString(request, new RnrBaseLogOutputJsonSerializeFilter()));
        ResponseEntity<String> entity =
                restTemplate.exchange(url, HttpMethod.POST, new HttpEntity<>(request), String.class, urlVariables);
        RnrResponse<T> result = JSON.parseObject(entity.getBody(), new TypeReference<RnrResponse<T>>(cls) {
        }.getType());
        LOGGER.info("postForResponse url: {},response: {},cost: {} ms", url,
                JSON.toJSONString(result, new RnrBaseLogOutputJsonSerializeFilter()),
                System.currentTimeMillis() - startTime);
        return result;
    }

    public static <T> RnrResponse<T> getForResponse(RestTemplate restTemplate, String url, Class<T> cls) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("getForResponse url: {}", url);
        ResponseEntity<String> entity = restTemplate.getForEntity(url, String.class);
        RnrResponse<T> result = JSON.parseObject(entity.getBody(), new TypeReference<RnrResponse<T>>(cls) {
        }.getType());
        LOGGER.info("getForResponse url: {},response: {},cost: {} ms", url,
                JSON.toJSONString(result, new RnrBaseLogOutputJsonSerializeFilter()),
                System.currentTimeMillis() - startTime);
        return result;
    }

    public static <T> T getForObject(RestTemplate restTemplate, String url, Class<T> cls) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("getForObject url: {}", url);
        ResponseEntity<String> entity = restTemplate.getForEntity(url, String.class);
        T result = JSON.parseObject(entity.getBody(), cls);
        LOGGER.info("getForObject url: {},response: {},cost: {} ms", url,
                JSON.toJSONString(result, new RnrBaseLogOutputJsonSerializeFilter()),
                System.currentTimeMillis() - startTime);
        return result;
    }
}
