package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseAuthenticationReqDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * Description: 自然人OCR识别请求DTO
 * <br />
 * CreateDate 2022-02-15 17:57
 *
 * @author yuy336
 **/
@Data
public class OcrNpReqDTO extends BaseAuthenticationReqDTO {

    /**
     * ocr识别的图片
     */
    @NotBlank(message = "图片不能为空")
    private String ocrPic;

    /**
     * 裁剪人像图片并返回
     * 0不处理（默认值）
     * 1 裁剪并返回
     */
    private String faceCut;
}
