package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseAuthenticationReqDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * Description: 活体检测请求DTO
 * <br />
 * CreateDate 2022-02-15 17:57
 *
 * @author yuy336
 **/
@Data
public class LivenessReqDTO extends BaseAuthenticationReqDTO {
    /**
     * 用于活体检测的视频，视频的BASE64值； BASE64编码后的大小不超过8M，支持mp4、avi、flv格式
     */
    @NotBlank(message = "活体视频不能为空")
    private String videoBase64;
    /**
     * 活体检测类型，取值：LIP/ACTION/SILENT。 LIP为数字模式，ACTION为动作模式，SILENT为静默模式，三种模式选择一种传入。
     */
    @NotBlank(message = "活体检测类型不能为空")
    private String livenessType;
    /**
     * 数字模式传参：数字验证码(1234)，需先调用接口获取数字验证码； 动作模式传参：传动作顺序(2,1 or 1,2)，需先调用接口获取动作顺序； 静默模式传参：不需要传递此参数。
     */
    private String validateData;

    /**
     * 额外配置，传入JSON字符串。 { "BestFrameNum": 2 //需要返回多张最佳截图，取值范围1-10 }
     */
    private String optional;
}
