package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseAuthenticationReqDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * Description: 人证比对请求dto
 * <br />
 * CreateDate 2022-02-23 19:42:41
 *
 * @author yuyi
 **/
@Data
public class IdCompareReqDTO extends BaseAuthenticationReqDTO {
    /**
     * 人脸照片
     */
    @NotBlank(message = "人脸照片不能为空")
    private String faceImg;

    /**
     * 证件号码
     */
    @NotBlank(message = "证件号码不能为空")
    private String certNumber;

    /**
     * 证件姓名
     */
    @NotBlank(message = "证件姓名不能为空")
    private String fullName;
}
