package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseAuthenticationReqDTO;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * Description: 人脸比对请求dto
 * <br />
 * CreateDate 2022-02-25 11:30:44
 *
 * @author yuyi
 **/
@Data
public class FaceCompareReqDTO  extends BaseAuthenticationReqDTO {

	/**
	 * 人脸照片
	 */
	@NotBlank(message = "人脸照片不能为空")
	private String faceImg;

	/**
	 * 基础照片
	 */
	@NotBlank(message = "基础照片不能为空")
	private String baseImg;
}
