package com.cusc.nirvana.user.rnr.base.dto;

import com.cusc.nirvana.user.rnr.base.common.BaseRnrDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 认证方式配置(AuthenticationWayConfig)传输对象类
 *
 * @author yuy336
 * @since 2022-02-14 14:20:36
 */
@ApiModel(value = "认证方式配置", description = "认证方式配置")
@Data
public class BaseAuthenticationWayConfigDTO extends BaseRnrDTO {

    private static final long serialVersionUID = 286468730442190735L;
    
    @ApiModelProperty(value = "认证方式编号")
    private String authWayNo;
    
    @ApiModelProperty(value = "认证名称")
    private String authWayName;

    @ApiModelProperty(value = "认证类型")
    private String authWayType;

    @ApiModelProperty(value = "认证实例")
    private String authWayInstance;

    @ApiModelProperty(value = "第三方系统编码，为了兼容老系统")
    private String systemCode;

    @ApiModelProperty(value = "URL")
    private String url;
    
    @ApiModelProperty(value = "用户名")
    private String username;
    
    @ApiModelProperty(value = "密码")
    private String password;
    
    @ApiModelProperty(value = "授权key")
    private String licenseKey;

    @ApiModelProperty(value = "请求扩展属性")
    private String reqExtend;

    @ApiModelProperty(value = "响应扩展属性")
    private String respExtend;
    
    @ApiModelProperty(value = "用量告警时限:秒、分、时、天、周、月")
    private Integer alarmTime;
    
    @ApiModelProperty(value = "用量告警数值")
    private Integer alarmValue;
    
    @ApiModelProperty(value = "告警邮箱")
    private String alarmEmail;
    
    @ApiModelProperty(value = "告警webhook")
    private String alarmWebhook;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "备注")
    private String comments;
}

