package com.cusc.nirvana.user.rnr.base.common;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;
import java.util.Date;

/**
 * <p>
 * rnr的DTO基类
 * </p>
 *
 * @author yuyi
 * @since 2021-10-21
 */
@Data
public class BaseRnrDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "数据库主键")
    private Long id;

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "逻辑删除（0-未删除，1-已删除）")
    private Integer isDelete;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "操作人")
    private String operator;

    @ApiModelProperty(value = "流水号：yyyyMMddHHmmssSSS+发起方标识+7 位随机数")
    private String serial_number;
}
