package com.cusc.nirvana.user.rnr.base.common;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.*;

/**
 * Description: 基础认证请求DTO
 * <br />
 * CreateDate 2022-02-14 15:28
 *
 * @author yuy336
 **/
@Data
public class BaseAuthenticationReqDTO implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 业务id
     */
    private String bizUuid;

    /**
     * 流水号
     */
    @NotBlank(message = "流水号不能为空")
    private String serialNumber;

    /**
     * 认证方式编号
     */
    private String authWayNo;

    /**
     * 租户编号
     */
    private String tenantNo;

    /**
     * 操作人
     */
    private String operator;
}
