/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util.crypt;

import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.HexUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm4Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sm4Util.class);
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    private Sm4Util() {
    }

    public static byte[] generateKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        return Sm4Util.generateKey(128);
    }

    public static byte[] generateKey(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static byte[] encryptEcbPaddingByte(byte[] key, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String encryptEcbPadding(String key, String data) {
        return Sm4Util.encryptEcbPaddingHex(key, data, false, null);
    }

    public static String encryptEcbPaddingHexString(String key, String data) {
        return Sm4Util.encryptEcbPaddingHex(key, data, true, null);
    }

    public static String encryptEcbPaddingHex(String key, String data, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty(data)) {
            return null;
        }
        try {
            byte[] keyBytes = hexString ? HexUtil.hexStringToBytes(key) : key.getBytes();
            byte[] dataBytes = CuscStringUtils.isNotEmpty(charset) ? data.getBytes(charset) : data.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = Sm4Util.encryptEcbPaddingByte(keyBytes, dataBytes);
            return Sm4Util.base64Encoder(encrypted);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.encryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static byte[] decryptEcbPaddingByte(byte[] key, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Sm4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static String decryptEcbPadding(String key, String data) {
        return Sm4Util.decryptEcbPaddingHex(key, data, false, null);
    }

    public static String decryptEcbPaddingHex(String key, String data, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty(data)) {
            return null;
        }
        try {
            byte[] keyBytes = hexString ? HexUtil.hexStringToBytes(key) : key.getBytes();
            byte[] decrypted = Sm4Util.decryptEcbPaddingByte(keyBytes, Sm4Util.base64Decoder(data));
            if (CuscStringUtils.isNotEmpty(charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static String decryptEcbPaddingHex(String key, byte[] base64Bytes, boolean hexString, String charset) {
        try {
            byte[] keyBytes = hexString ? HexUtil.hexStringToBytes(key) : key.getBytes();
            byte[] decrypted = Sm4Util.decryptEcbPaddingByte(keyBytes, base64Bytes);
            if (CuscStringUtils.isNotEmpty(charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static String decryptEcbPaddingHexDefault(String key, byte[] base64Bytes) {
        return Sm4Util.decryptEcbPaddingHex(key, base64Bytes, true, null);
    }

    public static String decryptEcbPaddingString(String key, String data) {
        return Sm4Util.decryptEcbPaddingHex(key, data, true, null);
    }

    public static byte[] encryptCbcPaddingByte(byte[] key, byte[] iv, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        Cipher cipher = Sm4Util.generateCbcCipher(ALGORITHM_NAME_CBC_PADDING, 1, key, iv);
        return cipher.doFinal(data);
    }

    public static String encryptCbcPadding(String key, String data, String iv) {
        return Sm4Util.encryptCbcPaddingHex(key, data, iv, false, null);
    }

    public static String encryptCbcPaddingHex(String key, String data, String iv, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty(data)) {
            return null;
        }
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            if (hexString) {
                keyBytes = HexUtil.hexStringToBytes(key);
                ivBytes = HexUtil.hexStringToBytes(iv);
            } else {
                keyBytes = key.getBytes();
                ivBytes = iv.getBytes();
            }
            byte[] dataBytes = CuscStringUtils.isNotEmpty(charset) ? data.getBytes(charset) : data.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = Sm4Util.encryptCbcPaddingByte(keyBytes, ivBytes, dataBytes);
            return Sm4Util.base64Encoder(encrypted);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.encryptCbcPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static byte[] decryptCbcPaddingByte(byte[] key, byte[] iv, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        Cipher cipher = Sm4Util.generateCbcCipher(ALGORITHM_NAME_CBC_PADDING, 2, key, iv);
        return cipher.doFinal(cipherText);
    }

    public static String decryptCbcPadding(String key, String data, String iv) {
        return Sm4Util.decryptCbcPaddingHex(key, data, iv, false, null);
    }

    public static String decryptCbcPaddingHex(String key, String data, String iv, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty(data)) {
            return null;
        }
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            if (hexString) {
                keyBytes = HexUtil.hexStringToBytes(key);
                ivBytes = HexUtil.hexStringToBytes(iv);
            } else {
                keyBytes = key.getBytes();
                ivBytes = iv.getBytes();
            }
            byte[] decrypted = Sm4Util.decryptCbcPaddingByte(keyBytes, ivBytes, Sm4Util.base64Decoder(data));
            if (CuscStringUtils.isNotEmpty(charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptCbcPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    public static String decryptCbcPaddingHex(String key, byte[] base64Bytes, String iv, boolean hexString, String charset) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            if (hexString) {
                keyBytes = HexUtil.hexStringToBytes(key);
                ivBytes = HexUtil.hexStringToBytes(iv);
            } else {
                keyBytes = key.getBytes();
                ivBytes = iv.getBytes();
            }
            byte[] decrypted = Sm4Util.decryptCbcPaddingByte(keyBytes, ivBytes, base64Bytes);
            if (CuscStringUtils.isNotEmpty(charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptCbcPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    private static Cipher generateCbcCipher(String algorithmName, int mode, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(mode, (Key)sm4Key, ivParameterSpec);
        return cipher;
    }

    private static String base64Encoder(byte[] encrypted) {
        return Base64.getEncoder().encodeToString(encrypted);
    }

    private static byte[] base64Decoder(String encrypted) throws IOException {
        return Base64.getDecoder().decode(encrypted);
    }

    public static void main(String[] args) {
        String sm4Key = "69352cf5af2b4d7a";
        String content = "Cusc@2022";
        System.out.println(Sm4Util.encryptEcbPadding(sm4Key, content));
        System.out.println(Sm4Util.decryptEcbPadding(sm4Key, "aHyhldlNwhQ/rZI9FCSX9g=="));
        System.out.println("313e527d850548249f14c36b0af06878".substring(16));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

