/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util.crypt;

import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AesUtil.class);
    private static final String ALG_AES = "AES";
    private static final String ALGORITHM = "AES/GCM/PKCS5Padding";
    private static final String ERROR_CODE_PARAM = "1001";

    public static String dcryptGCM(String content, String keyStr) {
        try {
            if (CuscStringUtils.isEmpty(content) || CuscStringUtils.isEmpty(keyStr)) {
                throw new CuscUserException(ERROR_CODE_PARAM, "ecryptGCM\u89e3\u5bc6\u5f02\u5e38,\u68c0\u67e5\u6587\u672c\u6216\u5bc6\u94a5");
            }
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            SecretKeySpec key = new SecretKeySpec(Base64.decodeBase64((String)keyStr), ALG_AES);
            cipher.init(1, key);
            byte[] message = Base64.decodeBase64((String)content);
            if (message.length < 28) {
                throw new IllegalArgumentException();
            }
            GCMParameterSpec params = new GCMParameterSpec(128, message, 0, 12);
            cipher.init(2, (Key)key, params);
            byte[] decryptData = cipher.doFinal(message, 12, message.length - 12);
            return new String(decryptData);
        }
        catch (Exception e) {
            LOGGER.error("dcryptGCM\u89e3\u5bc6\u6587\u672c\u5904\u7406\u5931\u8d25,error:{}", (Throwable)e);
            return null;
        }
    }

    public static String encryptGCM(String content, String keyStr) {
        try {
            if (CuscStringUtils.isEmpty(content) || CuscStringUtils.isEmpty(keyStr)) {
                throw new CuscUserException(ERROR_CODE_PARAM, "encryptGCM\u52a0\u5bc6\u5f02\u5e38,\u68c0\u67e5\u6587\u672c\u6216\u5bc6\u94a5");
            }
            SecretKeySpec secretKey = new SecretKeySpec(Base64.decodeBase64((String)keyStr), ALG_AES);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, secretKey);
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content.getBytes());
            assert (encryptData.length == content.getBytes().length + 16);
            byte[] message = new byte[12 + content.getBytes().length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.encodeBase64String((byte[])message);
        }
        catch (Exception e) {
            LOGGER.error("encryptGCM\u52a0\u5bc6\u6587\u672c\u5904\u7406\u5931\u8d25,error:{}", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        System.out.println(AesUtil.encryptGCM("Cusc@2022", "042e18fb003a4c7dbccf60758b58e55c"));
        System.out.println(AesUtil.dcryptGCM("rnF2auSElnrgw/3Xxvb78F/91Fq7pyUzSOgPJUikWAH6gcojOw==", "042e18fb003a4c7dbccf60758b58e55c"));
    }
}

