/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util;

import com.cusc.nirvana.user.util.CuscStringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    private static final String FORMAT_YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    private static final String FORMAT_YYYYMMDD = "yyyy-MM-dd";

    public static String currentTimeStr(String pattern) {
        return DateTimeFormatter.ofPattern(pattern).format(LocalDateTime.now());
    }

    public static String currentTimeStr() {
        return DateTimeFormatter.ofPattern(FORMAT_YYYYMMDDHHMMSS).format(LocalDateTime.now());
    }

    public static long stringHourToMills(String hour) {
        if (StringUtils.isBlank((CharSequence)hour)) {
            return 0L;
        }
        double h = Double.parseDouble(hour);
        return BigDecimal.valueOf(h * 3600.0 * 1000.0).longValue();
    }

    public static Date getTime(int hour, int intervalDays) {
        LocalDateTime endTime = LocalDateTime.now().withHour(hour).withMinute(0).withSecond(0).withNano(0).minusDays(intervalDays);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = endTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static LocalDateTime getDayEnd(LocalDateTime time) {
        return time.withHour(23).withMinute(59).withSecond(59).withNano(999999999);
    }

    public static LocalDateTime getDayStart(LocalDateTime time) {
        return time.withHour(0).withMinute(0).withSecond(0).withNano(0);
    }

    public static LocalDateTime convertDateToLDT(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date convertLDTToDate(LocalDateTime time) {
        return Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String formatOtherZoneTimestampToLocalDateTime(long timestamp, String pattern, String zoneId) {
        return DateTimeFormatter.ofPattern(pattern).format(ZonedDateTime.of(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()), ZoneId.of(zoneId)).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
    }

    public static String formatOtherZoneTimeStrToLocalDateTime(String timeStr, String pattern, String zoneId) {
        return DateTimeFormatter.ofPattern(pattern).format(ZonedDateTime.of(LocalDateTime.parse(timeStr, DateTimeFormatter.ofPattern(pattern)), ZoneId.of(zoneId)).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
    }

    public static String formatAutomaticZeros(String timeStr, String patternBefore, String patternAfter) {
        DateTimeFormatter inputFormat = DateTimeFormatter.ofPattern(patternBefore);
        DateTimeFormatter outputFormat = DateTimeFormatter.ofPattern(patternAfter);
        return LocalDateTime.parse(timeStr, inputFormat).format(outputFormat);
    }

    public static String formatDatetime(Date date) {
        return DateTimeFormatter.ofPattern(FORMAT_YYYYMMDDHHMMSS).format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    public static String getTheDayBefore(String pattern, long minusDays) {
        return DateTimeFormatter.ofPattern(pattern).format(LocalDateTime.now().minusDays(minusDays));
    }

    public static String currentDateStr() {
        return DateTimeFormatter.ofPattern(FORMAT_YYYYMMDD).format(LocalDateTime.now());
    }

    public static LocalDateTime str2LocalDateTime(String strTime) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(FORMAT_YYYYMMDDHHMMSS);
        LocalDateTime dateTime = LocalDateTime.parse(strTime, df);
        return dateTime;
    }

    public static Date str2Date(String strTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_YYYYMMDDHHMMSS);
        try {
            return simpleDateFormat.parse(strTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDatetimeForSrlNum() {
        return DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS").format(LocalDateTime.now());
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(new Date());
        }
        return calendar.get(1);
    }

    public static int compareDate(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    public static int daysBetween(Date beginDate, Date endDate) {
        Instant instantBegin = beginDate.toInstant();
        Instant instantEnd = endDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate beginLocalDate = instantBegin.atZone(zoneId).toLocalDate();
        LocalDate endLocalDate = instantEnd.atZone(zoneId).toLocalDate();
        Long ret = endLocalDate.toEpochDay() - beginLocalDate.toEpochDay();
        return ret.intValue();
    }

    public static Date parseDate(String dateStr, String format) {
        if (CuscStringUtils.isEmpty(format)) {
            format = FORMAT_YYYYMMDDHHMMSS;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error("DateUtil.parseDate error ! ", (Throwable)e);
            return null;
        }
    }

    public static long millisBetween(LocalDateTime beginDate, LocalDateTime endDate) {
        return Duration.between(beginDate, endDate).toMillis();
    }

    public static long secondBetween(LocalDateTime beginDate, LocalDateTime endDate) {
        return DateUtils.millisBetween(beginDate, endDate) / 1000L;
    }

    public static long minutesBetween(LocalDateTime beginDate, LocalDateTime endDate) {
        return Duration.between(beginDate, endDate).toMinutes();
    }

    public static long daysBetween(LocalDateTime beginDate, LocalDateTime endDate) {
        return Duration.between(beginDate, endDate).toDays();
    }

    public static long hoursBetween(LocalDateTime beginDate, LocalDateTime endDate) {
        return Duration.between(beginDate, endDate).toHours();
    }

    public static LocalDateTime parseLocalDateTime(String dateStr, String format) {
        if (CuscStringUtils.isEmpty(format)) {
            format = FORMAT_YYYYMMDDHHMMSS;
        }
        return LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(format));
    }

    public static String formatDate(LocalDateTime dateTime, String format) {
        if (CuscStringUtils.isEmpty(format)) {
            format = FORMAT_YYYYMMDDHHMMSS;
        }
        return dateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate parseLocalDate(String dateStr, String format) {
        if (CuscStringUtils.isEmpty(format)) {
            format = FORMAT_YYYYMMDDHHMMSS;
        }
        return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(format));
    }

    public static String formatDate(LocalDate dateTime, String format) {
        if (CuscStringUtils.isEmpty(format)) {
            format = FORMAT_YYYYMMDDHHMMSS;
        }
        return dateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static void main(String[] args) {
        LocalDateTime begin = LocalDateTime.now();
        System.out.println(DateUtils.secondBetween(begin, DateUtils.getDayEnd(begin)));
    }
}

