package com.cusc.nirvana.user.util.crypt;

import com.cusc.nirvana.user.util.CuscStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.io.*;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;

@Component
public class DataCryptService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DataCryptService.class);

    @Autowired
    private DataCryptProperties properties;

    //数据加密密钥
    private String sm4Key;

    public String getSm4Key() {
        return sm4Key;
    }

    /**
     * 为加密对象初始化
     */
    @PostConstruct
    public void init() {
        sm4Key = CryptKeyUtil.decrypt(properties.getPassword(), getPrivateKey());
    }

    /**
     * Description: 数据加密
     * <br />
     * CreateDate 2022-03-07 16:21:09
     *
     * @author yuyi
     **/
    public String encryptData(String content) {
        if (CuscStringUtils.isEmpty(content)) {
            return content;
        }
        return Sm4Util.encryptEcbPadding(sm4Key, content);
    }

    /**
     * Description: 集合数据加密
     * <br />
     * CreateDate 2022-03-07 16:21:09
     *
     * @author yuyi
     **/
    public List<String> encryptDataList(List<String> contentList) {
        if (CollectionUtils.isEmpty(contentList)) {
            return contentList;
        }
        List<String> ret = new ArrayList<>();
        for (String content : contentList) {
            ret.add(Sm4Util.encryptEcbPadding(sm4Key, content));
        }
        return ret;
    }

    public String decryptData(String content) {
        if (CuscStringUtils.isEmpty(content)) {
            return content;
        }
        return Sm4Util.decryptEcbPadding(sm4Key, content);
    }

    public PrivateKey getPrivateKey() {
        try {
            InputStream resource = this.getClass().getResourceAsStream(properties.getPrivateKey());
            ObjectInputStream inputStream = new ObjectInputStream(resource);
            return (PrivateKey) inputStream.readObject();
        } catch (Exception ex) {
            LOGGER.error("CryptUtil getPrivateKey error:{}", ex.getMessage());
        }
        return null;
    }
}
