package com.cusc.nirvana.user.exception;

/**
 * Description: 自定义异常
 * <br />
 * CreateDate 2021-10-28 13:32
 *
 * @author yuyi
 **/
public class CuscUserException extends RuntimeException {

    private static final long serialVersionUID = -2L;

    private final String code;
    private final String message;

    public CuscUserException(String code, String message, Throwable t) {
        super(message, t);
        this.code = code;
        this.message = message;
    }

    public CuscUserException(String code, String message) {
        super();
        this.code = code;
        this.message = message;
    }

    public CuscUserException(Integer code, String message) {
        super();
        this.code = code+"";
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

}
