/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util.crypt;

import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.HexUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm4Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sm4Utils.class);
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    private Sm4Utils() {
    }

    public static String encryptEcbPaddingHexString(String key, String data) {
        return Sm4Utils.encryptEcbPaddingHex(key, data, true, null);
    }

    public static String decryptEcbPaddingHexDefault(String key, byte[] base64Bytes) {
        return Sm4Utils.decryptEcbPaddingHex(key, base64Bytes, true, null);
    }

    private static String decryptEcbPaddingHex(String key, byte[] base64Bytes, boolean hexString, String charset) {
        try {
            byte[] keyBytes = hexString ? HexUtil.hexStringToBytes(key) : key.getBytes();
            byte[] decrypted = Sm4Utils.decryptEcbPaddingByte(keyBytes, base64Bytes);
            if (CuscStringUtils.isNotEmpty(charset)) {
                return new String(decrypted, charset);
            }
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.decryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    private static byte[] decryptEcbPaddingByte(byte[] key, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Sm4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    private static String encryptEcbPaddingHex(String key, String data, boolean hexString, String charset) {
        if (CuscStringUtils.isEmpty(data)) {
            return null;
        }
        try {
            byte[] keyBytes = hexString ? HexUtil.hexStringToBytes(key) : key.getBytes();
            byte[] dataBytes = CuscStringUtils.isNotEmpty(charset) ? data.getBytes(charset) : data.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = Sm4Utils.encryptEcbPaddingByte(keyBytes, dataBytes);
            return Sm4Utils.base64Encoder(encrypted);
        }
        catch (Exception e) {
            LOGGER.error("Sm4Util.encryptEcbPaddingHex error ! ", (Throwable)e);
            return null;
        }
    }

    private static String base64Encoder(byte[] encrypted) {
        return Base64.getEncoder().encodeToString(encrypted);
    }

    private static byte[] encryptEcbPaddingByte(byte[] key, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Sm4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

