/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util.crypt;

import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;
import com.cusc.nirvana.user.util.crypt.DataCryptProperties;
import com.cusc.nirvana.user.util.crypt.Sm4Util;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataCryptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCryptService.class);
    @Autowired
    private DataCryptProperties properties;
    private String sm4Key;

    public String getSm4Key() {
        return this.sm4Key;
    }

    @PostConstruct
    public void init() {
        this.sm4Key = CryptKeyUtil.decrypt(this.properties.getPassword(), this.getPrivateKey());
    }

    public String encryptData(String content) {
        if (CuscStringUtils.isEmpty(content)) {
            return content;
        }
        return Sm4Util.encryptEcbPadding(this.sm4Key, content);
    }

    public List<String> encryptDataList(List<String> contentList) {
        if (CollectionUtils.isEmpty(contentList)) {
            return contentList;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String content : contentList) {
            ret.add(Sm4Util.encryptEcbPadding(this.sm4Key, content));
        }
        return ret;
    }

    public String decryptData(String content) {
        if (CuscStringUtils.isEmpty(content)) {
            return content;
        }
        return Sm4Util.decryptEcbPadding(this.sm4Key, content);
    }

    public PrivateKey getPrivateKey() {
        try {
            InputStream resource = this.getClass().getResourceAsStream(this.properties.getPrivateKey());
            ObjectInputStream inputStream = new ObjectInputStream(resource);
            return (PrivateKey)inputStream.readObject();
        }
        catch (Exception ex) {
            LOGGER.error("CryptUtil getPrivateKey error:{}", (Object)ex.getMessage());
            return null;
        }
    }
}

