/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util.crypt;

import com.cusc.nirvana.spring.boot.SpringContextHelper;
import com.cusc.nirvana.user.util.crypt.DataCryptService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptKeyUtil {
    private static final Logger logger = LoggerFactory.getLogger(CryptKeyUtil.class);
    public static final String PADDING = "RSA/ECB/PKCS1Padding";

    public static Key getKey(byte[] arrBTmp) {
        byte[] arrB = new byte[8];
        int length = arrBTmp.length > 8 ? 8 : arrBTmp.length;
        System.arraycopy(arrBTmp, 0, arrB, 0, length);
        SecretKeySpec key = new SecretKeySpec(arrB, "DES");
        return key;
    }

    public static String encrypt(String text, PublicKey publicKey) {
        String cipherText = null;
        try {
            Cipher cipher = Cipher.getInstance(PADDING);
            cipher.init(1, publicKey);
            byte[] encryptedText = cipher.doFinal(text.getBytes(StandardCharsets.UTF_8));
            cipherText = CryptKeyUtil.byte2hex(encryptedText);
        }
        catch (Exception e) {
            logger.error("encrypt error", (Throwable)e);
        }
        return cipherText;
    }

    public static String decrypt(String text, PrivateKey privateKey) {
        String decryptString = null;
        try {
            Cipher cipher = Cipher.getInstance(PADDING);
            cipher.init(2, privateKey);
            byte[] dectyptedText = cipher.doFinal(CryptKeyUtil.hex2byte(text));
            decryptString = new String(dectyptedText, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("decrypt error", (Throwable)e);
        }
        return decryptString;
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder retString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            retString.append(Integer.toHexString(256 + (bytes[i] & 0xFF)).substring(1).toUpperCase());
        }
        return retString.toString();
    }

    public static byte[] hex2byte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static PrivateKey getPrivateKey(String name) {
        PrivateKey privateKey = null;
        try {
            byte[] decodeKey = Base64.decodeBase64((String)name);
            PKCS8EncodedKeySpec x509 = new PKCS8EncodedKeySpec(decodeKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(x509);
        }
        catch (Exception ex) {
            logger.error("CryptUtil getPrivateKey error:{}", (Object)ex.getMessage());
        }
        return privateKey;
    }

    public static PublicKey getPublicKey(String base64) {
        PublicKey publicKey = null;
        try {
            byte[] decodeKey = Base64.decodeBase64((String)base64);
            X509EncodedKeySpec x509 = new X509EncodedKeySpec(decodeKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(x509);
        }
        catch (Exception ex) {
            logger.error("CrypoUtil getPublicKey error:{}", (Object)ex.getMessage());
        }
        return publicKey;
    }

    public static KeyPair generateKey(int keySize) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(keySize == 0 ? 1024 : keySize);
            KeyPair key = keyGen.generateKeyPair();
            return key;
        }
        catch (Exception e) {
            logger.error("generateKey error:{}", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPublicKeyFile(PublicKey publicKey, String path) {
        File publicKeyFile = null;
        ObjectOutputStream publicKeyOS = null;
        FileOutputStream fos = null;
        try {
            publicKeyFile = new File(path);
            if (publicKeyFile.getParentFile() != null) {
                publicKeyFile.getParentFile().mkdirs();
            }
            if (publicKeyFile.exists()) {
                Files.delete(Paths.get(path, new String[0]));
            }
            if (publicKeyFile.createNewFile()) {
                fos = new FileOutputStream(publicKeyFile);
                publicKeyOS = new ObjectOutputStream(fos);
                publicKeyOS.writeObject(publicKey);
            }
        }
        catch (Exception e) {
            logger.error("getPublicKeyFile error:{}", (Throwable)e);
        }
        finally {
            if (publicKeyOS != null) {
                try {
                    publicKeyOS.close();
                }
                catch (IOException e) {
                    logger.error("close stream error", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("close stream error", (Throwable)e);
                }
            }
        }
        return publicKeyFile;
    }

    public static String encryptToBase64(String content) {
        return ((DataCryptService)SpringContextHelper.getBean(DataCryptService.class)).encryptData(content);
    }

    public static String decryptByBase64(String content) {
        return ((DataCryptService)SpringContextHelper.getBean(DataCryptService.class)).decryptData(content);
    }
}

