/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);
    private static SerializeConfig config = new SerializeConfig();
    private static final SerializerFeature[] features;

    public static String toJson(Object object) {
        try {
            return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
        }
        catch (Exception e) {
            LOGGER.error("JsonUtil | method=toJson() | \u5bf9\u8c61\u8f6c\u4e3aJson\u5b57\u7b26\u4e32 Error\uff01" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T toBean(String jsonStr, Class<T> clazz) {
        try {
            return (T)JSON.parseObject((String)jsonStr, clazz);
        }
        catch (Exception e) {
            LOGGER.error("JsonUtil | method=toBean() | Json \u8f6c\u4e3a  Jave Bean  Error\uff01" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Map<?, ?> toMap(String json) {
        try {
            return JSON.parseObject((String)json);
        }
        catch (Exception e) {
            LOGGER.error("JsonUtil | method=toMap() | Json \u8f6c\u4e3a   Map {},{}" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> toList(String text, Class<T> clazz) {
        try {
            return JSON.parseArray((String)text, clazz);
        }
        catch (Exception e) {
            LOGGER.error("JsonUtil | method=toList() | Json \u8f6c\u4e3a   List {},{}" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object getValueFromJson(String json, String key) {
        try {
            if (CuscStringUtils.isEmpty(json) || CuscStringUtils.isEmpty(key)) {
                return null;
            }
            return JSON.parseObject((String)json).getString(key);
        }
        catch (Exception e) {
            LOGGER.error("JsonUtil | method=getStringFromJson() | \u4ecejson\u83b7\u53d6\u6307\u5b9akey\u7684\u5b57\u7b26\u4e32 Error\uff01" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        config.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};
    }
}

