package com.cusc.nirvana.user.util.crypt;

import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * Description: AES加密算法
 * <br />
 * CreateDate 2021-11-04 09:14:32
 *
 * @author yuyi
 **/
public class AesUtil {

    private final static Logger LOGGER = LoggerFactory.getLogger(AesUtil.class);

    private final static String ALG_AES = "AES";

    private final static String ALGORITHM = "AES/GCM/PKCS5Padding";

    private final static String ERROR_CODE_PARAM = "1001";

    //解密
    public static String dcryptGCM(String content, String keyStr) {
        try {
            if (CuscStringUtils.isEmpty(content) || CuscStringUtils.isEmpty(keyStr)) {
                throw new CuscUserException(ERROR_CODE_PARAM, "ecryptGCM解密异常,检查文本或密钥");
            }
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            SecretKey key = new SecretKeySpec(Base64.decodeBase64(keyStr), ALG_AES);

            cipher.init(Cipher.ENCRYPT_MODE, key);
            byte[] message = Base64.decodeBase64(content);
            // 这里的12和16是加密的时候设置的偏移参数及加密长度
            if (message.length < 12 + 16) {
                throw new IllegalArgumentException();
            }
            GCMParameterSpec params = new GCMParameterSpec(128, message, 0, 12);
            cipher.init(Cipher.DECRYPT_MODE, key, params);
            byte[] decryptData = cipher.doFinal(message, 12, message.length - 12);
            return new String(decryptData);
        } catch (Exception e) {
            LOGGER.error("dcryptGCM解密文本处理失败,error:{}", e);
        }
        return null;
    }

    //加密
    public static String encryptGCM(String content, String keyStr) {
        try {
            if (CuscStringUtils.isEmpty(content) || CuscStringUtils.isEmpty(keyStr)) {
                throw new CuscUserException(ERROR_CODE_PARAM, "encryptGCM加密异常,检查文本或密钥");
            }
            SecretKey secretKey = new SecretKeySpec(Base64.decodeBase64(keyStr), ALG_AES);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            byte[] iv = cipher.getIV();
            assert iv.length == 12;// 偏移参数及长度要在解密的时候保持一致
            byte[] encryptData = cipher.doFinal(content.getBytes());
            assert encryptData.length == content.getBytes().length + 16;
            byte[] message = new byte[12 + content.getBytes().length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.encodeBase64String(message);
        } catch (Exception e) {
            LOGGER.error("encryptGCM加密文本处理失败,error:{}", e);
        }
        return null;
    }

    public static void main(String[] args) throws NoSuchPaddingException, NoSuchAlgorithmException,
            InvalidKeyException {
        System.out.println(encryptGCM("Cusc@2022","042e18fb003a4c7dbccf60758b58e55c"));
        //ccEyCOMijZZqGOi2zYTRSb1ml8gTEZ4z8msGFYnyk+C0teZECA==
        System.out.println(dcryptGCM("rnF2auSElnrgw/3Xxvb78F/91Fq7pyUzSOgPJUikWAH6gcojOw==",
                "042e18fb003a4c7dbccf60758b58e55c"));
    }
}
