package com.cusc.nirvana.user.util;

import org.apache.commons.lang3.RandomStringUtils;

/**
 * Description: 随机数工具类
 * <br />
 * CreateDate 2021-10-28 11:45
 *
 * @author yuyi
 **/
public class CuscRandomUtils {

    /**
     * Description: 生成指定长度的整形
     * <br />
     * CreateDate 2021-10-28 11:47:18
     *
     * @author yuyi
     **/
    public static int randomInt(int length) {
        return Integer.parseInt(RandomStringUtils.randomNumeric(length));
    }

    /**
     * Description: 生成指定长度的数字字符串
     * <br />
     * CreateDate 2021-10-28 11:47:18
     *
     * @author yuyi
     **/
    public static String randomNumeric(int length) {
        return RandomStringUtils.randomNumeric(length);
    }

    /**
     * Description: 生成指定最小长度和最大长度的随机数
     * <br />
     * CreateDate 2021-10-28 12:34:13
     *
     * @author yuyi
     **/
    public static String randomNumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomNumeric(minLengthInclusive, maxLengthExclusive);
    }

    public static void main(String[] args) {
        for (int i= 0; i< 2000; i ++){
            System.out.println(randomNumeric(5,8));
        }
    }
}
