/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.CommonYesOrNoEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.constants.RoleSceneEnum;
import com.cusc.nirvana.user.eiam.dao.UrlDao;
import com.cusc.nirvana.user.eiam.dao.entity.UrlPO;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.dto.EiamUrlDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceUrlSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IApplicationService;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UrlServiceImpl
extends ServiceImpl<UrlDao, UrlPO>
implements IUrlService {
    private static final Logger log = LoggerFactory.getLogger(UrlServiceImpl.class);
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    @Lazy
    private IUserService userService;
    @Autowired
    @Lazy
    private IApplicationService applicationService;

    public Response<List<ResourceUrlSimpleDTO>> queryAll(Integer isAuth) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"is_auth", (Object)isAuth);
        List recordList = this.list((Wrapper)queryWrapper);
        return Response.createSuccess((Object)this.getResourceUrlSimple(recordList));
    }

    @Transactional
    public Response addList(List<EiamUrlDTO> resourceUrlList) {
        return Response.createSuccess((Object)((UrlDao)this.baseMapper).addResourceUrlBatch(resourceUrlList));
    }

    public Long queryByUrl(EiamUrlDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"url", (Object)bean.getUrl());
        queryWrapper.eq((Object)"application_id", (Object)bean.getApplicationId());
        UrlPO resourceUrl = (UrlPO)this.getOne((Wrapper)queryWrapper);
        if (resourceUrl != null) {
            return resourceUrl.getId();
        }
        return null;
    }

    public Integer whiteListToRedis() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL);
        queryWrapper.eq((Object)"is_auth", (Object)1);
        ArrayList urlList = this.list((Wrapper)queryWrapper);
        HashSet<String> whiteList = new HashSet<String>();
        if (CollectionUtils.isEmpty((Collection)urlList)) {
            urlList = new ArrayList();
        }
        for (UrlPO url : urlList) {
            whiteList.add(url.getServerName() + url.getUrl());
        }
        try {
            this.cacheFactory.getSetService().addSet("CT:USER:AUTH:URL:WHITE:LIST", whiteList, true);
        }
        catch (CacheException e) {
            throw new CuscUserException(ResponseCode.SYS_BUSY.getCode() + "", ResponseCode.SYS_BUSY.getMsg());
        }
        return urlList.size();
    }

    @Transactional
    public Long add(EiamUrlDTO bean) {
        Long urlId = this.queryByUrl(bean);
        if (urlId != null && urlId > 0L) {
            return urlId;
        }
        UrlPO urlDO = new UrlPO();
        BeanUtils.copyProperties((Object)bean, (Object)urlDO);
        this.save((Object)urlDO);
        return urlDO.getId();
    }

    private List<ResourceUrlSimpleDTO> getResourceUrlSimple(List<UrlPO> recordList) {
        ArrayList<ResourceUrlSimpleDTO> retList = new ArrayList<ResourceUrlSimpleDTO>();
        for (UrlPO resource : recordList) {
            ResourceUrlSimpleDTO rusDto = new ResourceUrlSimpleDTO();
            BeanUtils.copyProperties((Object)resource, (Object)rusDto);
            retList.add(rusDto);
        }
        return retList;
    }

    @Async(value="dataToRedisExecutor")
    public void userRelUrlToRedis(String userId, String tenantNo, String appId) {
        this.userRoleResUrlToRedis(userId, tenantNo, appId);
    }

    @Async(value="dataToRedisExecutor")
    public void userRelRolUrlToRedis(String userId, String tenantNo, String appId) {
        this.userRoleResUrlToRedis(userId, tenantNo, appId);
    }

    @Async(value="dataToRedisExecutor")
    public void userRoleResUrlToRedis(String userId, String tenantNo, String appId) {
        Set urlSet = ((UrlDao)this.baseMapper).queryRoleUrlByUserId(userId, tenantNo, appId);
        this.putUrlRedis(userId, tenantNo, appId, urlSet);
    }

    @Async(value="dataToRedisExecutor")
    public void userRelAppUrlToRedis(String userId, String tenantNo) {
        ApplicationDTO applicationDTO = new ApplicationDTO();
        List taList = this.applicationService.queryByList(applicationDTO);
        if (CollectionUtils.isEmpty((Collection)taList)) {
            log.warn("userRelAppUrlToRedis \u672a\u627e\u5230\u79df\u6237\u5bf9\u5e94\u7684\u5e94\u7528\u3002tenantNo:{},userId:{}", (Object)tenantNo, (Object)userId);
        }
        for (ApplicationDTO tmpBean : taList) {
            this.userRelUrlToRedis(userId, tenantNo, tmpBean.getApplicationCode());
        }
    }

    public void delUserRelUrlRedis(String userId, String tenantNo, String appId) {
        HashSet<String> appIdSet = new HashSet<String>();
        if (CuscStringUtils.isEmpty((String)appId)) {
            ApplicationDTO applicationDTO = new ApplicationDTO();
            List taList = this.applicationService.queryByList(applicationDTO);
            if (CollectionUtils.isEmpty((Collection)taList)) {
                log.warn("userRelUrlToRedis \u672a\u627e\u5230\u79df\u6237\u5bf9\u5e94\u7684\u5e94\u7528\u3002tenantNo:{},userId:{}", (Object)tenantNo, (Object)userId);
            }
            for (ApplicationDTO tmpBean : taList) {
                appIdSet.add(tmpBean.getApplicationCode());
            }
        } else {
            appIdSet.add(appId);
        }
        for (String appIdStr : appIdSet) {
            this.delUrlRedis(userId, tenantNo, appIdStr);
        }
    }

    @Async(value="dataToRedisExecutor")
    public void roleRelUrlToRedis(String roleId, Integer roleScene, String tenantNo, String appId) {
        if (RoleSceneEnum.USER.getCode() == roleScene.intValue()) {
            UserRoleDTO userRole = new UserRoleDTO();
            userRole.setRoleId(roleId);
            userRole.setTenantNo(tenantNo);
            userRole.setIsDelete(Integer.valueOf(CommonDeleteEnum.NORMAL.getCode()));
            List userList = this.userService.queryUserByRoleId(userRole);
            if (!CollectionUtils.isEmpty((Collection)userList)) {
                for (UserDTO user : userList) {
                    this.userRelUrlToRedis(user.getUuid(), tenantNo, appId);
                }
            }
        }
    }

    @Async(value="dataToRedisExecutor")
    public void userListRelUrlToRedis(List<String> userIdList, String tenantNo, String appId) {
        if (CollectionUtils.isEmpty(userIdList)) {
            log.warn("userListRelUrlToRedis userIdList is empty. ");
        }
        for (String userId : userIdList) {
            this.userRelUrlToRedis(userId, tenantNo, appId);
        }
    }

    @Async(value="dataToRedisExecutor")
    public void tenantRelUrlToRedis(String tenantNo, String appId) {
        UserDTO user = new UserDTO();
        user.setTenantNo(tenantNo);
        user.setIsTenantAdmin(Integer.valueOf(CommonYesOrNoEnum.YES.getCode()));
        user = this.userService.getUser(user);
        if (user == null) {
            log.warn("tenantRelUrlToRedis\uff1a\u672a\u627e\u5230\u6709\u6548\u7684\u79df\u6237\u7ba1\u7406\u5458\u8d26\u53f7\u3002tenantNo:{}, appId:{}", (Object)tenantNo, (Object)appId);
            return;
        }
        Set urlSet = ((UrlDao)this.baseMapper).queryUrlByTenantNo(tenantNo, appId);
        this.putUrlRedis(user.getUuid(), tenantNo, appId, urlSet);
    }

    private void putUrlRedis(String userId, String tenantNo, String appId, Set<String> urlSet) {
        String redisKey = "CT:USER:AUTH:URL:USER:" + tenantNo + ":" + userId + "_" + appId;
        if (CollectionUtils.isEmpty(urlSet)) {
            log.warn("putUrlRedis urlSet is empty. key:" + redisKey);
            return;
        }
        try {
            this.cacheFactory.getSetService().addSet(redisKey, urlSet, true);
        }
        catch (CacheException e) {
            log.warn("putUrlRedis fail key: " + redisKey + " ", (Throwable)e);
        }
    }

    private void delUrlRedis(String userId, String tenantNo, String appId) {
        String redisKey = "CT:USER:AUTH:URL:USER:" + tenantNo + ":" + userId + "_" + appId;
        try {
            this.cacheFactory.getSetService().delete(new String[]{redisKey});
        }
        catch (CacheException e) {
            log.warn("delUrlRedis fail key: " + redisKey + " ", (Throwable)e);
        }
    }
}

