/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.CommonStatusEnum;
import com.cusc.nirvana.user.eiam.constants.CommonYesOrNoEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.RoleConverter;
import com.cusc.nirvana.user.eiam.dao.RoleDao;
import com.cusc.nirvana.user.eiam.dao.entity.RolePO;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.dto.RoleSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IRoleResourceService;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.eiam.util.CuscSqlUtils;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RoleServiceImpl
extends ServiceImpl<RoleDao, RolePO>
implements IRoleService {
    @Autowired
    private IRoleResourceService roleResourceService;

    @Transactional
    public RoleDTO add(RoleDTO entity) {
        RolePO entity0 = new RolePO();
        BeanUtils.copyProperties((Object)entity, (Object)entity0);
        String roleUuid = CuscStringUtils.generateUuid();
        entity0.setUuid(roleUuid);
        if (CuscStringUtils.isEmpty((String)entity0.getParentId())) {
            entity0.setParentId("0");
        }
        RoleDTO checkRole = new RoleDTO();
        checkRole.setRoleName(entity.getRoleName());
        List checkRoleList = this.queryRoleByParams(checkRole);
        if (!CollectionUtils.isEmpty((Collection)checkRoleList)) {
            throw new CuscUserException(ResponseCode.ROLE_NAME_REPEAT.getCode(), ResponseCode.ROLE_NAME_REPEAT.getMsg());
        }
        this.save((Object)entity0);
        entity.setUuid(entity0.getUuid());
        if (!CollectionUtils.isEmpty((Collection)entity.getResourceUuidList())) {
            RoleResourceDTO rrDTO = new RoleResourceDTO();
            rrDTO.setResourceUuidList(entity.getResourceUuidList());
            rrDTO.setRoleId(roleUuid);
            rrDTO.setTenantNo(entity.getTenantNo());
            rrDTO.setApplicationId(entity.getApplicationId());
            rrDTO.setCreator(entity.getCreator());
            this.roleResourceService.addBatchResource(rrDTO);
        }
        return entity;
    }

    @Transactional
    public RoleDTO update(RoleDTO entity) {
        RolePO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null || CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(), ResponseCode.ROLE_INVALID.getMsg());
        }
        entity.setId(entity0.getId());
        entity.setRoleScene(entity0.getRoleScene());
        if (CuscStringUtils.isNotEmpty((String)entity.getRoleName())) {
            RoleDTO checkRole = new RoleDTO();
            checkRole.setRoleName(entity.getRoleName());
            checkRole.setId(entity0.getId());
            checkRole.setTenantNo(entity.getTenantNo());
            checkRole.setApplicationId(entity.getApplicationId());
            List checkRoleList = this.queryRoleByParams(checkRole);
            if (!CollectionUtils.isEmpty((Collection)checkRoleList)) {
                throw new CuscUserException(ResponseCode.ROLE_NAME_REPEAT.getCode(), ResponseCode.ROLE_NAME_REPEAT.getMsg());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)entity.getResourceUuidList())) {
            RoleResourceDTO rrDTO = new RoleResourceDTO();
            rrDTO.setResourceUuidList(entity.getResourceUuidList());
            rrDTO.setRoleId(entity.getUuid());
            rrDTO.setTenantNo(entity.getTenantNo());
            rrDTO.setCreator(entity.getOperator());
            this.roleResourceService.addBatchResource(rrDTO);
        }
        BeanUtils.copyProperties((Object)entity, (Object)entity0);
        entity0.setUuid(null);
        this.updateById((Object)entity0);
        return entity;
    }

    @Transactional
    public RoleDTO delete(RoleDTO entity) {
        RolePO entity0 = this.getPoByUuid(entity.getUuid(), entity.getTenantNo());
        if (entity0 == null) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(), ResponseCode.ROLE_INVALID.getMsg());
        }
        if (CommonDeleteEnum.DELETED.getCode() == entity0.getIsDelete().intValue()) {
            return RoleConverter.INSTANCE.poToDto(entity0);
        }
        RoleResourceDTO rrDTO = new RoleResourceDTO();
        rrDTO.setRoleId(entity0.getUuid());
        rrDTO.setTenantNo(entity.getTenantNo());
        this.roleResourceService.addBatchResource(rrDTO);
        RolePO tmpRole = new RolePO();
        tmpRole.setId(entity0.getId());
        tmpRole.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        tmpRole.setOperator(entity.getOperator());
        this.updateById((Object)tmpRole);
        return RoleConverter.INSTANCE.poToDto(entity0);
    }

    public RoleDTO get(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(null != entity.getId(), (Object)"id", (Object)entity.getId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getRoleCode()), (Object)"role_code", (Object)entity.getRoleCode());
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.eq((Object)"application_id", (Object)entity.getApplicationId());
        RolePO record = (RolePO)this.getOne((Wrapper)queryWrapper);
        RoleDTO resp = new RoleDTO();
        if (record != null) {
            BeanUtils.copyProperties((Object)record, (Object)resp);
        }
        return resp;
    }

    public PageResult<RoleDTO> page(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getApplicationId()), (Object)"application_id", (Object)entity.getApplicationId());
        queryWrapper.eq(entity.getRoleType() != null, (Object)"role_type", (Object)entity.getRoleType());
        queryWrapper.eq(entity.getStatus() != null, (Object)"status", (Object)entity.getStatus());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getParentId()), (Object)"parent_id", (Object)entity.getParentId());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getRoleCode()), (Object)"role_code", (Object)entity.getRoleCode());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getRoleName()), (Object)"role_name", (Object)entity.getRoleName());
        queryWrapper.eq(entity.getId() != null, (Object)"id", (Object)entity.getId());
        if (!CollectionUtils.isEmpty((Collection)entity.getResourceUuidList())) {
            StringBuilder existsSql = new StringBuilder();
            for (String resUuid : entity.getResourceUuidList()) {
                existsSql.append("'");
                existsSql.append(CuscSqlUtils.transactSQLInjection((String)resUuid));
                existsSql.append("',");
            }
            existsSql.deleteCharAt(existsSql.length() - 1);
            queryWrapper.exists("select 1 from eiam_role_resource where is_delete = 0 and role_id = eiam_role.uuid and tenant_no = '" + CuscSqlUtils.transactSQLInjection((String)entity.getTenantNo()) + "' and resource_id in  (" + existsSql + ")");
        }
        if (CuscStringUtils.isNotEmpty((String)entity.getPositionId())) {
            queryWrapper.exists("select 1 from eiam_position_role where is_delete = 0 and role_id = eiam_role.uuid and tenant_no = '" + CuscSqlUtils.transactSQLInjection((String)entity.getTenantNo()) + "' and  position_id = '" + CuscSqlUtils.transactSQLInjection((String)entity.getPositionId()) + "'");
        }
        if (CuscStringUtils.isNotEmpty((String)entity.getUserId())) {
            queryWrapper.exists("select 1 from eiam_user_role where is_delete = 0 and role_id = eiam_role.uuid and tenant_no = '" + CuscSqlUtils.transactSQLInjection((String)entity.getTenantNo()) + "' and user_id = '" + CuscSqlUtils.transactSQLInjection((String)entity.getPositionId()) + "'");
        }
        Page page = (Page)this.page((IPage)new Page((long)entity.getCurrPage().intValue(), (long)entity.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, RoleDTO.class);
    }

    public List<RoleSimpleDTO> query(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getRoleName()), (Object)"role_name", (Object)entity.getRoleName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getRoleCode()), (Object)"role_code", (Object)entity.getRoleCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUuid()), (Object)"uuid", (Object)entity.getUuid());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getApplicationId()), (Object)"application_id", (Object)entity.getApplicationId());
        queryWrapper.eq(entity.getRoleType() != null, (Object)"role_type", (Object)entity.getRoleType());
        queryWrapper.eq(entity.getRoleScene() != null, (Object)"role_scene", (Object)entity.getRoleScene());
        queryWrapper.eq(entity.getStatus() != null, (Object)"status", (Object)entity.getStatus());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getParentId()), (Object)"parent_id", (Object)entity.getParentId());
        List recordList = this.list((Wrapper)queryWrapper);
        return this.getRoleSimple(recordList);
    }

    public RoleDTO getByUuid(RoleDTO bean) {
        RolePO rolePO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        return RoleConverter.INSTANCE.poToDto(rolePO);
    }

    public List<RoleSimpleDTO> getByUuids(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"uuid", (Collection)entity.getUuidList());
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        List recordList = this.list((Wrapper)queryWrapper);
        return this.getRoleSimple(recordList);
    }

    public List<RoleDTO> queryRoleByUserId(UserRoleDTO entity) {
        return RoleConverter.INSTANCE.poListToDtoList(((RoleDao)this.baseMapper).queryRoleByUserId(entity));
    }

    public List<RoleSimpleDTO> queryRoleByName(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.eq((Object)"role_name", (Object)entity.getRoleName());
        queryWrapper.ne(entity.getId() != null, (Object)"id", (Object)entity.getId());
        queryWrapper.ne((Object)"uuid", (Object)entity.getUuid());
        List recordList = this.list((Wrapper)queryWrapper);
        return this.getRoleSimple(recordList);
    }

    public RoleDTO frozen(RoleDTO bean) {
        RolePO rolePO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (rolePO == null) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(), ResponseCode.ROLE_INVALID.getMsg());
        }
        RolePO tmpBean = new RolePO();
        tmpBean.setId(rolePO.getId());
        tmpBean.setStatus(Integer.valueOf(CommonStatusEnum.DISABLE.getCode()));
        this.updateById((Object)tmpBean);
        return RoleConverter.INSTANCE.poToDto(rolePO);
    }

    public RoleDTO unfreeze(RoleDTO bean) {
        RolePO rolePO = this.getPoByUuid(bean.getUuid(), bean.getTenantNo());
        if (rolePO == null) {
            throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(), ResponseCode.ROLE_INVALID.getMsg());
        }
        RolePO tmpBean = new RolePO();
        tmpBean.setId(rolePO.getId());
        tmpBean.setStatus(Integer.valueOf(CommonStatusEnum.ENABLE.getCode()));
        this.updateById((Object)tmpBean);
        return RoleConverter.INSTANCE.poToDto(rolePO);
    }

    public Response<Boolean> queryHideSensitiveByUserId(UserRoleDTO bean) {
        List roleList = this.queryRoleByUserId(bean);
        if (CollectionUtils.isEmpty((Collection)roleList)) {
            return Response.createSuccess((Object)false);
        }
        for (RoleDTO role : roleList) {
            if (role.getHideSensitiveInfo() == null || CommonYesOrNoEnum.YES.getCode() != role.getHideSensitiveInfo().intValue()) continue;
            return Response.createSuccess((Object)true);
        }
        return Response.createSuccess((Object)false);
    }

    private List<RoleSimpleDTO> queryRoleByParams(RoleDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getRoleName()), (Object)"role_name", (Object)entity.getRoleName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getRoleCode()), (Object)"role_code", (Object)entity.getRoleCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUuid()), (Object)"uuid", (Object)entity.getUuid());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getApplicationId()), (Object)"application_id", (Object)entity.getApplicationId());
        queryWrapper.ne(entity.getId() != null, (Object)"id", (Object)entity.getId());
        return this.getRoleSimple(this.list((Wrapper)queryWrapper));
    }

    private RolePO getPoByUuid(String uuid, String tenantNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.eq((Object)"tenant_no", (Object)tenantNo);
        return (RolePO)this.getOne((Wrapper)queryWrapper);
    }

    private List<RoleSimpleDTO> getRoleSimple(List<RolePO> recordList) {
        ArrayList<RoleSimpleDTO> retList = new ArrayList<RoleSimpleDTO>();
        for (RolePO role : recordList) {
            RoleSimpleDTO rsDto = new RoleSimpleDTO();
            BeanUtils.copyProperties((Object)role, (Object)rsDto);
            retList.add(rsDto);
        }
        return retList;
    }
}

