/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.CommonStatusEnum;
import com.cusc.nirvana.user.eiam.constants.ResourceAuthTypeEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.ResourceConverter;
import com.cusc.nirvana.user.eiam.dao.ResourceDao;
import com.cusc.nirvana.user.eiam.dao.entity.ResourcePO;
import com.cusc.nirvana.user.eiam.dto.ResourceBatchDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceTreeDTO;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IResourceService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ResourceServiceImpl
extends ServiceImpl<ResourceDao, ResourcePO>
implements IResourceService {
    private static final Logger log = LoggerFactory.getLogger(ResourceServiceImpl.class);
    private static final String RESOURCE_SEPARATOR = "-";

    public List<ResourceDTO> queryResourceByRoleId(RoleResourceDTO entity) {
        List resourceList = ((ResourceDao)this.baseMapper).queryResourceByRoleId(entity);
        ArrayList<ResourceDTO> retList = new ArrayList<ResourceDTO>();
        if (CollectionUtils.isEmpty((Collection)resourceList)) {
            return retList;
        }
        for (ResourcePO resource : resourceList) {
            ResourceDTO resDTO = new ResourceDTO();
            BeanUtils.copyProperties((Object)resource, (Object)resDTO);
            retList.add(resDTO);
        }
        return retList;
    }

    public Response<List<ResourceSimpleDTO>> query(ResourceDTO entity) {
        List recordList = this.queryResourceList(entity);
        return Response.createSuccess((Object)this.getResourceSimple(recordList));
    }

    private List<ResourcePO> queryResourceList(ResourceDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL);
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getUuid()), (Object)"uuid", (Object)entity.getUuid());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getApplicationId()), (Object)"application_id", (Object)entity.getApplicationId());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)entity.getResourceName()), (Object)"resource_name", (Object)entity.getResourceName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getParentId()), (Object)"parent_id", (Object)entity.getParentId());
        queryWrapper.eq(entity.getResourceType() != null, (Object)"resource_type", (Object)entity.getResourceType());
        return this.list((Wrapper)queryWrapper);
    }

    @Transactional
    public Response<Integer> addList(ResourceBatchDTO resourceBatch) {
        List resouceList = resourceBatch.getResourceList();
        if (CollectionUtils.isEmpty((Collection)resouceList)) {
            return Response.createSuccess((Object)0);
        }
        Set resCodeSetDb = ((ResourceDao)this.baseMapper).queryResourceCodeSet(resourceBatch.getApplicationId());
        HashSet resCodeSetInput = new HashSet();
        ArrayList addList = new ArrayList();
        this.getAllResourceNode(resouceList, addList, "0", resourceBatch.getApplicationId(), resourceBatch.getCreator(), resCodeSetInput, resCodeSetDb);
        log.info("ResourceServiceImpl.addList addResourceBatch \u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(addList));
        ((ResourceDao)this.baseMapper).addResourceBatch(addList);
        List delList = this.getDelResource(resCodeSetDb, resCodeSetInput);
        log.info("ResourceServiceImpl.addList deleteByCode \u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)delList));
        this.deleteByCode(delList, resourceBatch.getApplicationId());
        return Response.createSuccess((Object)addList.size());
    }

    public List<ResourceSimpleDTO> queryResourceByUserId(UserRoleDTO entity) {
        List resourceList = entity.getAuthType() != null && ResourceAuthTypeEnum.USER.getCode() == entity.getAuthType().intValue() ? ((ResourceDao)this.baseMapper).queryResourceUserByUserId(entity) : ((ResourceDao)this.baseMapper).queryResourceRoleByUserId(entity);
        return this.getResourceSimple(resourceList);
    }

    public ResourcePO getResourceDOByCode(ResourceDTO entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"resource_code", (Object)entity.getResourceCode());
        queryWrapper.eq((Object)"application_id", (Object)entity.getApplicationId());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL);
        return (ResourcePO)this.getOne((Wrapper)queryWrapper);
    }

    @Transactional
    public Integer deleteByCode(List<String> codeList, String appId) {
        if (CollectionUtils.isEmpty(codeList)) {
            return 0;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"application_id", (Object)appId);
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.in((Object)"resource_code", codeList);
        ResourcePO rrDO = new ResourcePO();
        rrDO.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        this.update((Object)rrDO, (Wrapper)updateWrapper);
        return codeList.size();
    }

    public void compareResource(List<ResourceTreeDTO> resourceList) {
        List dbList = this.queryResourceList(new ResourceDTO());
        Set resCodeSetDb = ((ResourceDao)this.baseMapper).queryResourceCodeSet("1");
        HashSet resCodeSetInput = new HashSet();
        ArrayList inputList = new ArrayList();
        this.getAllResourceNode(resourceList, inputList, "0", "1", "creater", resCodeSetInput, resCodeSetDb);
        log.info("inputList :" + JSON.toJSONString(inputList));
        for (ResourcePO res : inputList) {
            boolean isNotExists = true;
            for (ResourcePO resTmp : dbList) {
                if (!res.getResourceCode().equals(resTmp.getResourceCode())) continue;
                isNotExists = false;
            }
            if (!isNotExists) continue;
            log.info("compareResource:" + JSON.toJSONString((Object)res));
        }
    }

    public PageResult<ResourceDTO> queryByPage(ResourceDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)bean.getResourceCode()), (Object)"resource_code", (Object)bean.getResourceCode());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)bean.getResourceName()), (Object)"resource_name", (Object)bean.getResourceName());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getApplicationId()), (Object)"application_id", (Object)bean.getApplicationId());
        queryWrapper.eq(bean.getParentId() != null, (Object)"parent_id", (Object)bean.getParentId());
        queryWrapper.eq(bean.getStatus() != null, (Object)"status", (Object)bean.getStatus());
        Page page = (Page)this.page((IPage)new Page((long)bean.getCurrPage().intValue(), (long)bean.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, ResourceDTO.class);
    }

    public ResourceDTO getByUuid(ResourceDTO bean) {
        ResourcePO resourcePO = this.getPoByUuid(bean.getUuid());
        return ResourceConverter.INSTANCE.poToDto(resourcePO);
    }

    @Transactional
    public ResourceDTO add(ResourceDTO resource) {
        ResourcePO resourcePO = ResourceConverter.INSTANCE.dtoToPo(resource);
        resourcePO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)resourcePO);
        resource.setUuid(resourcePO.getUuid());
        return resource;
    }

    @Transactional
    public ResourceDTO update(ResourceDTO bean) {
        ResourcePO resourcePO = this.getPoByUuid(bean.getUuid());
        if (resourcePO == null) {
            return null;
        }
        ResourcePO tmpBean = ResourceConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(resourcePO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(ResourceDTO resource) {
        ResourcePO resourcePO = this.getPoByUuid(resource.getUuid());
        if (resourcePO == null) {
            throw new CuscUserException(ResponseCode.RESOURCE_INVALID.getCode(), ResponseCode.RESOURCE_INVALID.getMsg());
        }
        ResourcePO tmpApp = new ResourcePO();
        tmpApp.setId(resourcePO.getId());
        tmpApp.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpApp);
    }

    @Transactional
    public boolean frozen(ResourceDTO resource) {
        ResourcePO resourcePO = this.getPoByUuid(resource.getUuid());
        if (resourcePO == null) {
            throw new CuscUserException(ResponseCode.RESOURCE_INVALID.getCode(), ResponseCode.RESOURCE_INVALID.getMsg());
        }
        ResourcePO tmpApp = new ResourcePO();
        tmpApp.setId(resourcePO.getId());
        tmpApp.setStatus(Integer.valueOf(CommonStatusEnum.DISABLE.getCode()));
        return this.updateById((Object)tmpApp);
    }

    @Transactional
    public boolean unfreeze(ResourceDTO resource) {
        ResourcePO resourcePO = this.getPoByUuid(resource.getUuid());
        if (resourcePO == null) {
            throw new CuscUserException(ResponseCode.RESOURCE_INVALID.getCode(), ResponseCode.RESOURCE_INVALID.getMsg());
        }
        ResourcePO tmpApp = new ResourcePO();
        tmpApp.setId(resourcePO.getId());
        tmpApp.setStatus(Integer.valueOf(CommonStatusEnum.ENABLE.getCode()));
        return this.updateById((Object)tmpApp);
    }

    public Response<List<String>> generateResSql(ResourceDTO bean) {
        ResourceDTO paramRes = new ResourceDTO();
        List ret = new ArrayList();
        paramRes.setApplicationId(bean.getApplicationId());
        if (bean.isAllChild()) {
            ResourcePO tmpRes = this.getPoByUuid(bean.getUuid());
            if (tmpRes == null) {
                return Response.createSuccess(ret);
            }
            paramRes.setTreeCode(tmpRes.getTreeCode() + RESOURCE_SEPARATOR);
        } else {
            paramRes.setUuid(bean.getUuid());
        }
        ret = ((ResourceDao)this.baseMapper).generateResSql(paramRes);
        return Response.createSuccess(ret);
    }

    private List<ResourceSimpleDTO> getResourceSimple(List<ResourcePO> recordList) {
        ArrayList<ResourceSimpleDTO> retList = new ArrayList<ResourceSimpleDTO>();
        for (ResourcePO resource : recordList) {
            ResourceSimpleDTO rsDto = new ResourceSimpleDTO();
            BeanUtils.copyProperties((Object)resource, (Object)rsDto);
            retList.add(rsDto);
        }
        return retList;
    }

    private ResourcePO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)0);
        return (ResourcePO)this.getOne((Wrapper)queryWrapper);
    }

    private List<String> getDelResource(Set<String> resCodeSetDb, Set<String> resCodeSetInput) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String resCode : resCodeSetDb) {
            if (resCodeSetInput.contains(resCode)) continue;
            ret.add(resCode);
        }
        return ret;
    }

    private void getAllResourceNode(List<ResourceTreeDTO> children, List<ResourcePO> recordList, String parentUuid, String appId, String creator, Set<String> resCodeSetInput, Set<String> resCodeSetDb) {
        for (ResourceTreeDTO treeNode : children) {
            ResourcePO temp = null;
            if (CuscStringUtils.isEmpty((String)treeNode.getResourceCode())) continue;
            resCodeSetInput.add(treeNode.getResourceCode());
            ResourcePO resource = new ResourcePO();
            BeanUtils.copyProperties((Object)treeNode, (Object)resource);
            resource.setParentId(parentUuid);
            resource.setApplicationId(appId);
            if (resCodeSetDb.contains(treeNode.getResourceCode())) {
                ResourceDTO resDTO = new ResourceDTO();
                resDTO.setApplicationId(appId);
                resDTO.setResourceCode(treeNode.getResourceCode());
                temp = this.getResourceDOByCode(resDTO);
            }
            if (temp != null && CuscStringUtils.isNotEmpty((String)temp.getUuid())) {
                resource.setUuid(temp.getUuid());
                resource.setCreator(temp.getCreator());
            } else {
                resource.setUuid(CuscStringUtils.generateUuid());
                resource.setCreator(creator);
            }
            recordList.add(resource);
            if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) continue;
            this.getAllResourceNode(treeNode.getChildren(), recordList, resource.getUuid(), appId, creator, resCodeSetInput, resCodeSetDb);
        }
    }
}

