/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserResourceDTO;
import com.cusc.nirvana.user.eiam.dto.UserSimpleDTO;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserResourceService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.eiam.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userResource"})
public class UserResourceController {
    @Autowired
    private IUserResourceService userResourceService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IUrlService urlService;

    @PostMapping(value={"/queryByList"})
    public Response<List<UserResourceDTO>> queryByList(@RequestBody UserResourceDTO bean) {
        return Response.createSuccess((Object)this.userResourceService.queryByList(bean));
    }

    @PostMapping(value={"/add"})
    public Response add(@RequestBody UserResourceDTO bean) {
        return Response.createSuccess((Object)this.userResourceService.insert(bean));
    }

    @PostMapping(value={"/allUserRelUrlToRedis"})
    @ApiOperation(value="\u5237\u65b0\u6240\u6709\u7528\u6237\u7684URL\u81f3\u7f13\u5b58", notes="\u5237\u65b0\u6240\u6709\u7528\u6237\u7684URL\u81f3\u7f13\u5b58")
    public Response allUserRelUrlToRedis(@RequestBody UserResourceDTO userResDTO) {
        CommonParamterCheck.appIdAndTenantNoRequired((String)userResDTO.getApplicationId(), (String)userResDTO.getTenantNo());
        UserDTO user = new UserDTO();
        user.setTenantNo(userResDTO.getTenantNo());
        List userList = this.userService.queryListUser(user);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            for (UserSimpleDTO userSimpleDTO : userList) {
                this.urlService.userRelRolUrlToRedis(userSimpleDTO.getUuid(), userResDTO.getTenantNo(), userResDTO.getApplicationId());
            }
        }
        return Response.createSuccess();
    }

    @PostMapping(value={"/insertBatchResource"})
    public Response insertBatchResource(@RequestBody UserResourceDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getUserId())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        int ret = this.userResourceService.insertBatchResource(bean);
        this.urlService.userRelUrlToRedis(bean.getUserId(), bean.getTenantNo(), bean.getApplicationId());
        return Response.createSuccess((Object)ret);
    }

    @PostMapping(value={"/deleteByUserId"})
    public Response deleteByUserId(@RequestBody UserResourceDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getUserId())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        return Response.createSuccess((Object)this.userResourceService.deleteByUserId(bean));
    }
}

