/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserPasswordDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.dto.UserSimpleDTO;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.eiam.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    IUserService userService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65b0\u589e\u7528\u6237")
    public Response add(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getPhone())) {
            return Response.createError((String)ResponseCode.USER_PHONE_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_PHONE_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.addUser(entity));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u5220\u9664\u7528\u6237")
    public Response delete(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.deleteUser(entity));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u4fe1\u606f", notes="\u66f4\u65b0\u7528\u6237\u4fe1\u606f")
    public Response update(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.updateUser(entity));
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u96c6\u5408\u4fe1\u606f", notes="\u67e5\u8be2\u7528\u6237\u96c6\u5408\u4fe1\u606f")
    public Response<List<UserSimpleDTO>> query(@RequestBody UserDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.queryListUser(entity));
    }

    @PostMapping(value={"/get"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7528\u6237\u4fe1\u606f", notes="\u67e5\u8be2\u5355\u4e2a\u7528\u6237\u4fe1\u606f")
    public Response<UserDTO> get(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.getUser(entity));
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7528\u6237\u4fe1\u606f(page)", notes="\u5206\u9875\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    public Response<PageResult<UserDTO>> page(@RequestBody UserDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.pageListUser(entity));
    }

    @PostMapping(value={"/frozen"})
    @ApiOperation(value="\u51bb\u7ed3\u7528\u6237", notes="\u51bb\u7ed3\u7528\u6237")
    public Response frozen(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.frozen(entity));
    }

    @PostMapping(value={"/unfreeze"})
    @ApiOperation(value="\u89e3\u51bb\u7528\u6237", notes="\u89e3\u51bb\u7528\u6237")
    public Response unfreeze(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.unfreeze(entity));
    }

    @PostMapping(value={"/getByUuid"})
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u7528\u6237\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u7528\u6237\u8be6\u60c5")
    public Response<UserDTO> getByUuid(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.getByUuid(entity));
    }

    @PostMapping(value={"/getByUuids"})
    @ApiOperation(value="\u901a\u8fc7id\u96c6\u5408\u67e5\u8be2\u7528\u6237\u8be6\u60c5", notes="\u901a\u8fc7id\u96c6\u5408\u67e5\u8be2\u7528\u6237\u8be6\u60c5")
    public Response<List<UserSimpleDTO>> getByUuids(@RequestBody UserDTO entity) {
        if (CollectionUtils.isEmpty((Collection)entity.getUuidList())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.getByUuids(entity));
    }

    @PostMapping(value={"/queryUserByRoleId"})
    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272id\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u901a\u8fc7\u89d2\u8272\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    public Response<List<UserDTO>> queryUserByRoleId(@RequestBody UserRoleDTO entity) {
        if (entity.getIsDelete() == null) {
            entity.setIsDelete(Integer.valueOf(CommonDeleteEnum.NORMAL.getCode()));
        }
        if (CuscStringUtils.isEmpty((String)entity.getTenantNo()) || CuscStringUtils.isEmpty((String)entity.getApplicationId()) || CuscStringUtils.isEmpty((String)entity.getRoleId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.userService.queryUserByRoleId(entity));
    }

    @PostMapping(value={"/getByPhone"})
    @ApiOperation(value="\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u8be6\u60c5", notes="\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u8be6\u60c5")
    public Response<UserDTO> getByPhone(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getPhone())) {
            return Response.createError((String)ResponseCode.USER_PHONE_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_PHONE_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.getUser(entity));
    }

    @PostMapping(value={"/getByUserName"})
    @ApiOperation(value="\u901a\u8fc7\u767b\u5f55\u540d\u67e5\u8be2\u7528\u6237\u8be6\u60c5", notes="\u901a\u8fc7\u767b\u5f55\u540d\u67e5\u8be2\u7528\u6237\u8be6\u60c5")
    public Response<UserDTO> getByUserName(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUserName())) {
            return Response.createError((String)ResponseCode.USER_NAME_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_NAME_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.getUser(entity));
    }

    @PostMapping(value={"/getByEmail"})
    @ApiOperation(value="\u901a\u8fc7\u90ae\u7bb1\u67e5\u8be2\u7528\u6237\u8be6\u60c5", notes="\u901a\u8fc7\u90ae\u7bb1\u67e5\u8be2\u7528\u6237\u8be6\u60c5")
    public Response<UserDTO> getByEmail(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getEmail())) {
            return Response.createError((String)ResponseCode.USER_EMAIL_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_EMAIL_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.getUser(entity));
    }

    @PostMapping(value={"/changeTenantAdmin"})
    @ApiOperation(value="\u66f4\u6362\u79df\u6237\u7ba1\u7406\u5458\u8d26\u53f7", notes="\u66f4\u6362\u79df\u6237\u7ba1\u7406\u5458\u8d26\u53f7")
    public Response changeTenantAdmin(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid()) || CuscStringUtils.isEmpty((String)entity.getTenantNo())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        return Response.createSuccess((Object)this.userService.changeTenantAdmin(entity));
    }

    @PostMapping(value={"/allUserRelUrlToRedis"})
    @ApiOperation(value="\u5c06\u79df\u6237\u4e0b\u7684\u6240\u6709\u7528\u6237\u5bf9\u5e94\u7684url\u5199\u5165redis", notes="\u5c06\u79df\u6237\u4e0b\u7684\u6240\u6709\u7528\u6237\u5bf9\u5e94\u7684url\u5199\u5165redis")
    public Response allUserRelUrlToRedis(@RequestBody UserDTO entity) {
        this.userService.allUserRelUrlToRedis(entity);
        return Response.createSuccess();
    }

    @PostMapping(value={"/changePassword"})
    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801", notes="\u4fee\u6539\u5bc6\u7801")
    public Response changePassword(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid()) || CuscStringUtils.isEmpty((String)entity.getPassword()) || CuscStringUtils.isEmpty((String)entity.getNewPassword())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.changePassword(entity));
    }

    @PostMapping(value={"/resetPassword"})
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801", notes="\u91cd\u7f6e\u5bc6\u7801")
    public Response<Boolean> resetPassword(@RequestBody UserPasswordDTO bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        return Response.createSuccess((Object)this.userService.resetPassword(bean));
    }

    @PostMapping(value={"/getUserOnline"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u662f\u5426\u5728\u7ebf", notes="\u67e5\u8be2\u7528\u6237\u662f\u5426\u5728\u7ebf")
    public Response getUserOnline(@RequestBody UserDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.userService.getUserOnline(entity));
    }
}

