/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.EiamUrlDTO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserSimpleDTO;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.eiam.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resource/url"})
public class UrlController {
    private static final Logger log = LoggerFactory.getLogger(UrlController.class);
    @Autowired
    IUrlService urlService;
    @Autowired
    private IUserService userService;

    @PostMapping(value={"/queryByUrl"})
    @ApiOperation(value="\u901a\u8fc7url \u548c \u5e94\u7528id \u67e5\u8be2url\u5bf9\u5e94\u7684id", notes="\u901a\u8fc7url \u548c \u5e94\u7528id \u67e5\u8be2url\u5bf9\u5e94\u7684id")
    public Response<Long> queryByUrl(@RequestBody EiamUrlDTO bean) {
        return Response.createSuccess((Object)this.urlService.queryByUrl(bean));
    }

    @PostMapping(value={"/whiteListToRedis"})
    @ApiOperation(value="\u521d\u59cb\u5316\u767d\u540d\u5355", notes="\u521d\u59cb\u5316\u767d\u540d\u5355")
    public Response<Integer> whiteListToRedis() {
        return Response.createSuccess((Object)this.urlService.whiteListToRedis());
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0url", notes="\u6dfb\u52a0url")
    public Response<Long> add(@RequestBody EiamUrlDTO bean) {
        return Response.createSuccess((Object)this.urlService.add(bean));
    }

    @PostMapping(value={"/userRoleResUrlToRedis"})
    @ApiOperation(value="\u5c06\u7528\u6237\u6388\u6743\u7684url\u5199\u5165redis", notes="\u5c06\u7528\u6237\u6388\u6743\u7684url\u5199\u5165redis")
    public Response userRoleResUrlToRedis(@RequestBody EiamUrlDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getUserId()) || CuscStringUtils.isEmpty((String)bean.getApplicationId()) || CuscStringUtils.isEmpty((String)bean.getTenantNo())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        this.urlService.userRoleResUrlToRedis(bean.getUserId(), bean.getTenantNo(), bean.getApplicationId());
        return Response.createSuccess();
    }

    @PostMapping(value={"/allUserRoleResToRedis"})
    @ApiOperation(value="\u5237\u65b0\u6240\u6709\u7528\u6237\u7684URL\u81f3\u7f13\u5b58", notes="\u5237\u65b0\u6240\u6709\u7528\u6237\u7684URL\u81f3\u7f13\u5b58")
    public Response allUserRoleResToRedis(@RequestBody EiamUrlDTO bean) {
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        UserDTO user = new UserDTO();
        user.setTenantNo(bean.getTenantNo());
        List userList = this.userService.queryListUser(user);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            for (UserSimpleDTO userSimpleDTO : userList) {
                this.urlService.userRoleResUrlToRedis(userSimpleDTO.getUuid(), bean.getTenantNo(), bean.getApplicationId());
            }
        }
        return Response.createSuccess();
    }
}

