/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.constants.RoleSceneEnum;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.service.IRoleResourceService;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roleResource"})
public class RoleResourceController {
    @Autowired
    private IRoleResourceService roleResourceService;
    @Autowired
    private IUrlService urlService;

    @PostMapping(value={"/add"})
    public Response add(@RequestBody RoleResourceDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getRoleId()) || CuscStringUtils.isEmpty((String)bean.getTenantNo()) || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.roleResourceService.add(bean));
    }

    @PostMapping(value={"/deleteBatchRole"})
    public Response deleteBatchRole(@RequestBody RoleResourceDTO bean) {
        if (CollectionUtils.isEmpty((Collection)bean.getRoleIdList()) || CuscStringUtils.isEmpty((String)bean.getTenantNo()) || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        for (String roleId : bean.getRoleIdList()) {
            bean.setRoleId(roleId);
            this.roleResourceService.addBatchResource(bean);
            this.urlService.roleRelUrlToRedis(roleId, Integer.valueOf(RoleSceneEnum.USER.getCode()), bean.getTenantNo(), bean.getApplicationId());
        }
        return Response.createSuccess((Object)bean.getRoleIdList().size());
    }

    @PostMapping(value={"/queryByList"})
    public Response<List<RoleResourceDTO>> queryByList(@RequestBody RoleResourceDTO userRole) {
        return Response.createSuccess((Object)this.roleResourceService.queryByList(userRole));
    }
}

