/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
public class RoleController {
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IUrlService urlService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u89d2\u8272", notes="\u65b0\u589e\u89d2\u8272")
    public Response add(@RequestBody RoleDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getRoleCode()) || CuscStringUtils.isEmpty((String)entity.getRoleName()) || entity.getRoleType() == null) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        RoleDTO ret = this.roleService.add(entity);
        this.urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess((Object)ret);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272", notes="\u66f4\u65b0\u89d2\u8272")
    public Response update(@RequestBody RoleDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.ROLE_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        RoleDTO ret = this.roleService.update(entity);
        this.urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess((Object)ret);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u89d2\u8272", notes="\u5220\u9664\u89d2\u8272")
    public Response delete(@RequestBody RoleDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.ROLE_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        RoleDTO ret = this.roleService.delete(entity);
        this.urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess((Object)true);
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272", notes="\u67e5\u8be2\u89d2\u8272")
    public Response<List<RoleSimpleDTO>> query(@RequestBody RoleDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.roleService.query(entity));
    }

    @PostMapping(value={"/get"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u89d2\u8272", notes="\u67e5\u8be2\u5355\u4e2a\u89d2\u8272")
    public Response<RoleDTO> get(@RequestBody RoleDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.roleService.get(entity));
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2(page)", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<RoleDTO>> page(@RequestBody RoleDTO entity) {
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.roleService.page(entity));
    }

    @PostMapping(value={"/getByUuid"})
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u89d2\u8272\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u89d2\u8272\u8be6\u60c5")
    public Response<RoleDTO> getByUuid(@RequestBody RoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUuid())) {
            return Response.createError((String)ResponseCode.ROLE_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.roleService.getByUuid(entity));
    }

    @PostMapping(value={"/getByUuids"})
    @ApiOperation(value="\u901a\u8fc7id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u8be6\u60c5", notes="\u901a\u8fc7id\u96c6\u5408\u67e5\u8be2\u89d2\u8272\u8be6\u60c5")
    public Response<List<RoleSimpleDTO>> getByUuids(@RequestBody RoleDTO entity) {
        if (CollectionUtils.isEmpty((Collection)entity.getUuidList())) {
            return Response.createError((String)ResponseCode.ROLE_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.roleService.getByUuids(entity));
    }

    @PostMapping(value={"/queryRoleByUserId"})
    @ApiOperation(value="\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u89d2\u8272\u4fe1\u606f", notes="\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u89d2\u8272\u4fe1\u606f")
    public Response<List<RoleDTO>> queryRoleByUserId(@RequestBody UserRoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUserId())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.roleService.queryRoleByUserId(entity));
    }

    @PostMapping(value={"/queryRoleByName"})
    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272\u540d\u79f0\u67e5\u8be2\u89d2\u8272\u4fe1\u606f", notes="\u901a\u8fc7\u89d2\u8272\u540d\u79f0\u67e5\u8be2\u89d2\u8272\u4fe1\u606f")
    public Response<List<RoleSimpleDTO>> queryRoleByName(@RequestBody RoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getRoleName())) {
            return Response.createError((String)ResponseCode.ROLE_NAME_NOT_NULL.getMsg(), (Integer)ResponseCode.ROLE_NAME_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return Response.createSuccess((Object)this.roleService.queryRoleByName(entity));
    }

    @PostMapping(value={"/frozen"})
    @ApiOperation(value="\u51bb\u7ed3", notes="\u51bb\u7ed3")
    public Response frozen(@RequestBody RoleDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getUuid())) {
            return Response.createError((String)ResponseCode.ROLE_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        RoleDTO ret = this.roleService.frozen(bean);
        this.urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess((Object)true);
    }

    @PostMapping(value={"/unfreeze"})
    @ApiOperation(value="\u89e3\u51bb", notes="\u89e3\u51bb")
    public Response unfreeze(@RequestBody RoleDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getUuid())) {
            return Response.createError((String)ResponseCode.ROLE_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.ROLE_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        RoleDTO ret = this.roleService.unfreeze(bean);
        this.urlService.roleRelUrlToRedis(ret.getUuid(), ret.getRoleScene(), ret.getTenantNo(), ret.getApplicationId());
        return Response.createSuccess((Object)true);
    }

    @PostMapping(value={"/queryHideSensitiveByUserId"})
    @ApiOperation(value="\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u662f\u5426\u8131\u654f", notes="\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u662f\u5426\u8131\u654f   false \u8131\u654f\uff0c  true \u4e0d\u8131\u654f")
    public Response<Boolean> queryHideSensitiveByUserId(@RequestBody UserRoleDTO entity) {
        if (entity == null || CuscStringUtils.isEmpty((String)entity.getUserId())) {
            return Response.createError((String)ResponseCode.USER_UUID_NOT_NULL.getMsg(), (Integer)ResponseCode.USER_UUID_NOT_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)entity.getApplicationId(), (String)entity.getTenantNo());
        return this.roleService.queryHideSensitiveByUserId(entity);
    }
}

