/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.config;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.user.util.CuscStringUtils;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class WebLogAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebLogAspect.class);

    @Pointcut(value="execution(* com.cusc.nirvana.user.*.*.controller.*.*(..))")
    public void webLog() {
    }

    @Around(value="webLog()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        String requestId = CuscStringUtils.generateUuid();
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String params = "";
        if ("POST".equals(method)) {
            Object[] args = proceedingJoinPoint.getArgs();
            params = JSON.toJSONString((Object)args);
        } else if ("GET".equals(method)) {
            params = request.getQueryString();
        }
        LOGGER.info("requestId:{} , request url:{} , method:{} , params:{}", new Object[]{requestId, url, method, params});
        Object result = proceedingJoinPoint.proceed();
        LOGGER.info("requestId:{} , response url:{} , result:{} , cost:{} ms", new Object[]{requestId, url, JSON.toJSONString((Object)result), System.currentTimeMillis() - startTime});
        return result;
    }
}

