/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.ciam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.ciam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.ciam.converter.UserThirdpartyConverter;
import com.cusc.nirvana.user.ciam.dao.UserThirdpartyDao;
import com.cusc.nirvana.user.ciam.dao.entity.UserThirdpartyPO;
import com.cusc.nirvana.user.ciam.dto.CiamUserThirdpartyDTO;
import com.cusc.nirvana.user.ciam.service.IUserThirdpartyService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserThirdpartyServiceImpl
extends ServiceImpl<UserThirdpartyDao, UserThirdpartyPO>
implements IUserThirdpartyService {
    public CiamUserThirdpartyDTO getByUuid(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO record = this.getPoByUuid(bean.getUuid());
        return UserThirdpartyConverter.INSTANCE.poToDto(record);
    }

    public List<CiamUserThirdpartyDTO> queryByList(CiamUserThirdpartyDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return UserThirdpartyConverter.INSTANCE.poListToDtoList(record);
    }

    @Transactional
    public CiamUserThirdpartyDTO insert(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO userThirdpartyPO = UserThirdpartyConverter.INSTANCE.dtoToPo(bean);
        userThirdpartyPO.setUuid(CuscStringUtils.generateUuid());
        this.save((Object)userThirdpartyPO);
        bean.setUuid(userThirdpartyPO.getUuid());
        return bean;
    }

    @Transactional
    public CiamUserThirdpartyDTO update(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO userThirdpartyPO = this.getPoByUuid(bean.getUuid());
        if (userThirdpartyPO == null) {
            return null;
        }
        UserThirdpartyPO tmpBean = UserThirdpartyConverter.INSTANCE.dtoToPo(bean);
        tmpBean.setId(userThirdpartyPO.getId());
        this.updateById((Object)tmpBean);
        return bean;
    }

    @Transactional
    public boolean deleteById(CiamUserThirdpartyDTO bean) {
        UserThirdpartyPO userThirdpartyPO = this.getPoByUuid(bean.getUuid());
        if (userThirdpartyPO == null) {
            return false;
        }
        UserThirdpartyPO tmpBean = new UserThirdpartyPO();
        tmpBean.setId(userThirdpartyPO.getId());
        tmpBean.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        return this.updateById((Object)tmpBean);
    }

    private UserThirdpartyPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (UserThirdpartyPO)this.getOne((Wrapper)queryWrapper);
    }
}

