/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.ciam.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cusc.nirvana.common.result.BeanUtilsHelper;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.ciam.constants.ResponseCode;
import com.cusc.nirvana.user.ciam.dao.entity.CiamUserPO;
import com.cusc.nirvana.user.ciam.dto.CiamUserDTO;
import com.cusc.nirvana.user.ciam.service.ICiamUserService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user/ciam"})
public class CiamUserController {
    private static final Logger log = LoggerFactory.getLogger(CiamUserController.class);
    @Autowired
    ICiamUserService userService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e(add)", notes="\u6d4b\u8bd5demo")
    public Response add(CiamUserDTO entity) {
        try {
            CiamUserPO entity0 = new CiamUserPO();
            BeanUtils.copyProperties((Object)entity, (Object)entity0);
            return Response.createSuccess((Object)this.userService.save((Object)entity0));
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5demo,\u65b0\u589e\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a:{}", (Throwable)e);
            return Response.createError((String)"\u670d\u52a1\u5fd9", Collections.emptyList());
        }
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0(update)", notes="\u6d4b\u8bd5demo")
    public Response update(CiamUserDTO entity) {
        try {
            CiamUserPO entity0 = new CiamUserPO();
            BeanUtils.copyProperties((Object)entity, (Object)entity0);
            return Response.createSuccess((Object)this.userService.updateById((Object)entity0));
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5demo,\u66f4\u65b0\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a:{}", (Throwable)e);
            return Response.createError((String)"\u670d\u52a1\u5fd9", Collections.emptyList());
        }
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2(query)", notes="\u6d4b\u8bd5demo")
    public Response<List<CiamUserDTO>> query() {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.orderByDesc((Object)"u_time2");
            queryWrapper.eq((Object)"del2", (Object)0);
            List list = this.userService.list((Wrapper)queryWrapper);
            List result = BeanUtilsHelper.convert((List)list, CiamUserDTO.class);
            return Response.createSuccess((Object)result);
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5demo,\u67e5\u8be2\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a:{}", (Throwable)e);
            return Response.createError((String)"\u670d\u52a1\u5fd9", Collections.emptyList());
        }
    }

    @PostMapping(value={"/get"})
    @ApiOperation(value="\u67e5\u8be2(get)", notes="\u6d4b\u8bd5demo")
    public Response<CiamUserDTO> get(long id) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"id", (Object)id);
            queryWrapper.eq((Object)"del2", (Object)0);
            CiamUserPO record = (CiamUserPO)this.userService.getOne((Wrapper)queryWrapper);
            CiamUserDTO resp = new CiamUserDTO();
            BeanUtils.copyProperties((Object)record, (Object)resp);
            return Response.createSuccess((Object)resp);
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5demo,\u67e5\u8be2\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a:{}", (Throwable)e);
            return Response.createError((String)"\u670d\u52a1\u5fd9", Collections.emptyList());
        }
    }

    @PostMapping(value={"/queryUserByUuid"})
    @ApiOperation(value="\u67e5\u8be2(queryUser)", notes="\u67e5\u8be2(queryUser)")
    public Response<CiamUserDTO> queryUserByUuid(@RequestBody CiamUserDTO entity) {
        log.info("queryUserByUuid\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"uuid", (Object)entity.getUuid());
            queryWrapper.eq((Object)"is_delete", (Object)0);
            CiamUserPO record = (CiamUserPO)this.userService.getOne((Wrapper)queryWrapper);
            if (null == record) {
                return Response.createError((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f", Collections.emptyList());
            }
            CiamUserDTO resp = new CiamUserDTO();
            BeanUtils.copyProperties((Object)record, (Object)resp);
            return Response.createSuccess((Object)resp);
        }
        catch (Exception e) {
            return Response.createError((String)"\u67e5\u8be2\u5931\u8d25", Collections.emptyList());
        }
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2(page)", notes="\u6d4b\u8bd5demo")
    public PageResult<CiamUserDTO> page(long current, long size) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.orderByDesc((Object)"u_time2");
            queryWrapper.eq((Object)"del2", (Object)0);
            Page page = (Page)this.userService.page((IPage)new Page(current, size), (Wrapper)queryWrapper);
            return PageHelper.convert((Page)page, CiamUserDTO.class);
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5demo,\u5206\u9875\u67e5\u8be2\u65b9\u6cd5\u6267\u884c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a:{}", (Throwable)e);
            return PageResult.createError((String)"\u670d\u52a1\u5fd9");
        }
    }

    @PostMapping(value={"/getByPhone"})
    @ApiOperation(value="\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u901a\u8fc7\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    public Response<List<CiamUserDTO>> getByPhone(@RequestBody CiamUserDTO bean) {
        CiamUserDTO user;
        if (CuscStringUtils.isEmpty((String)bean.getPhoneNum())) {
            return Response.createError((String)ResponseCode.PARAMETER_NOT_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NOT_NULL.getCode());
        }
        ArrayList<CiamUserDTO> retList = null;
        if (bean.getTenantNo() != null && (user = this.userService.getUserByPhoneTenantNo(bean)) != null) {
            retList = new ArrayList<CiamUserDTO>();
            retList.add(user);
        }
        return Response.createSuccess(retList);
    }

    @PostMapping(value={"/getByPhoneTenantNo"})
    @ApiOperation(value="\u901a\u8fc7\u624b\u673a\u53f7\u548c\u79df\u6237\u7f16\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u901a\u8fc7\u624b\u673a\u53f7\u548c\u79df\u6237\u7f16\u53f7\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    public Response<CiamUserDTO> getByPhoneTenantNo(@RequestBody CiamUserDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getTenantNo()) || CuscStringUtils.isEmpty((String)bean.getPhoneNum())) {
            return Response.createError((String)ResponseCode.PARAMETER_NOT_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NOT_NULL.getCode());
        }
        return Response.createSuccess((Object)this.userService.getUserByPhoneTenantNo(bean));
    }

    @PostMapping(value={"/createUser"})
    @ApiOperation(value="\u5b9e\u540d\u6ce8\u518c", notes="\u521b\u5efa\u7528\u6237")
    public Response createUser(@RequestBody CiamUserDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getTenantNo()) || CuscStringUtils.isEmpty((String)entity.getPhoneNum())) {
            return Response.createError((String)ResponseCode.PARAMETER_NOT_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NOT_NULL.getCode());
        }
        return Response.createSuccess((Object)this.userService.addOrGet(entity));
    }
}

