/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.service.impl;

import com.cache.CacheFactory;
import com.cache.constants.CacheConstants;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import com.cusc.nirvana.user.auth.common.dto.LogoutDTO;
import com.cusc.nirvana.user.auth.common.dto.RefreshTokenHashDTO;
import com.cusc.nirvana.user.auth.common.dto.UserTokenListDTO;
import com.cusc.nirvana.user.auth.common.service.AppConfigService;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.dto.UserLoginResp;
import com.cusc.nirvana.user.auth.identification.dto.UserNameLoginReq;
import com.cusc.nirvana.user.auth.identification.service.ITokenService;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.eiam.service.IUserOrganService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TokenServiceImpl
implements ITokenService {
    private static final Logger log = LoggerFactory.getLogger(TokenServiceImpl.class);
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    private AppConfigService appConfigService;
    @Resource
    private IUserOrganService userOrganService;

    public Response<Oauth2Token> createOauth2TokenByMobile(MobileLoginReq bean, UserDTO user) {
        UserLoginResp userLogin = new UserLoginResp();
        userLogin.setUserId(user.getUuid());
        userLogin.setLoginName(bean.getPhone().substring(0, 3) + "****" + bean.getPhone().substring(bean.getPhone().length() - 4));
        return this.createOauth2Token(userLogin, bean.getApplicationId(), user.getTenantNo());
    }

    public Response<Oauth2Token> createOauth2TokenByMobileXP(MobileLoginReq bean, UserDTO user) {
        UserLoginResp userLogin = new UserLoginResp();
        userLogin.setUserId(UUID.randomUUID().toString().replace("-", ""));
        userLogin.setLoginName(bean.getPhone().substring(0, 3) + "****" + bean.getPhone().substring(bean.getPhone().length() - 4));
        return this.createOauth2Token(userLogin, bean.getApplicationId(), user.getTenantNo());
    }

    public Response<Oauth2Token> createOauth2TokenByUserName(UserNameLoginReq bean, UserDTO user) {
        UserLoginResp userLogin = new UserLoginResp();
        userLogin.setUserId(user.getUuid());
        userLogin.setLoginName(bean.getUserName());
        return this.createOauth2Token(userLogin, bean.getApplicationId(), user.getTenantNo());
    }

    public Response logout(LogoutDTO logoutDTO) {
        String accessToken = logoutDTO.getAccessToken();
        try {
            AccessTokenHashDTO accessTokenHashDTO = (AccessTokenHashDTO)this.cacheFactory.getExpireHashService().getHash("CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + accessToken, AccessTokenHashDTO.class);
            if (accessTokenHashDTO != null) {
                this.cacheFactory.getExpireHashService().delete(new String[]{"CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + accessTokenHashDTO.getRefresh()});
                String userTokenListKey = "CT:USER:AUTH:TOKEN:USER:" + accessTokenHashDTO.getTenantNo() + ":" + accessTokenHashDTO.getUserId();
                List userList = this.cacheFactory.getExpireListService().getList(userTokenListKey, UserTokenListDTO.class);
                userList = this.deleteListContent(userList, accessToken);
                this.cacheFactory.getListService().delete(new String[]{userTokenListKey});
                if (!CollectionUtils.isEmpty((Collection)userList)) {
                    int userTokenInfoTtl = Math.toIntExact(this.cacheFactory.getListService().getKeyExpireTime(userTokenListKey));
                    this.cacheFactory.getExpireListService().setExpireList(userTokenListKey, userList, userTokenInfoTtl);
                }
                this.cacheFactory.getExpireHashService().delete(new String[]{"CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + accessToken});
            }
        }
        catch (CacheException e) {
            log.error("logout \u8bbf\u95eereids\u5931\u8d25 :{}", (Throwable)e);
            return Response.createError((String)ResponseCode.LOGOUT_FAIL.getMsg(), (String)(ResponseCode.LOGOUT_FAIL.getCode() + ""));
        }
        return Response.createSuccess();
    }

    public Response kickOutByUserId(String userId, String tenantNo, String appId) {
        try {
            String userTokenListKey = "CT:USER:AUTH:TOKEN:USER:" + tenantNo + ":" + userId;
            List userList = this.cacheFactory.getExpireListService().getList(userTokenListKey, UserTokenListDTO.class);
            if (CollectionUtils.isEmpty((Collection)userList)) {
                return Response.createSuccess();
            }
            ArrayList<UserTokenListDTO> userListNew = new ArrayList<UserTokenListDTO>();
            for (UserTokenListDTO userToken : userList) {
                if (!userToken.getAppId().equals(appId)) {
                    userListNew.add(userToken);
                    continue;
                }
                this.cacheFactory.getExpireHashService().delete(new String[]{"CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + userToken.getRefresh()});
                this.cacheFactory.getExpireHashService().delete(new String[]{"CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + userToken.getAccess()});
            }
            if (!CollectionUtils.isEmpty(userListNew)) {
                int userTokenInfoTtl = Math.toIntExact(this.cacheFactory.getListService().getKeyExpireTime(userTokenListKey));
                this.cacheFactory.getExpireListService().delete(new String[]{userTokenListKey});
                this.cacheFactory.getExpireListService().setExpireList(userTokenListKey, userListNew, userTokenInfoTtl);
            }
        }
        catch (CacheException e) {
            log.error("kickOutByUserId \u8bbf\u95eereids\u5931\u8d25 :{}", (Throwable)e);
            return Response.createError((String)ResponseCode.KICK_OUT_FAIL.getMsg(), (String)(ResponseCode.KICK_OUT_FAIL.getCode() + ""));
        }
        return Response.createSuccess();
    }

    public Response tokenRenewal(String accessToken, String appId) {
        ApplicationDTO appBean = this.appConfigService.getAppConfigByCode(appId);
        try {
            this.cacheFactory.getExpireHashService().expireKey("CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + accessToken, appBean.getRenewalTokenTime().intValue(), CacheConstants.TimeType.EX);
            AccessTokenHashDTO accessTokenHashDTO = (AccessTokenHashDTO)this.cacheFactory.getExpireHashService().getHash("CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + accessToken, AccessTokenHashDTO.class);
            if (accessTokenHashDTO != null) {
                this.cacheFactory.getExpireListService().updateExpire("CT:USER:AUTH:TOKEN:USER:" + accessTokenHashDTO.getTenantNo() + ":" + accessTokenHashDTO.getUserId(), appBean.getRenewalTokenTime().intValue());
            }
        }
        catch (CacheException e) {
            log.error("tokenRenewal \u8bbf\u95eereids\u5931\u8d25 :{}", (Throwable)e);
            return Response.createError();
        }
        return Response.createSuccess();
    }

    private List<UserTokenListDTO> checkExpireContent(List<UserTokenListDTO> userList) {
        if (!CollectionUtils.isEmpty(userList)) {
            ArrayList<UserTokenListDTO> ret = new ArrayList<UserTokenListDTO>();
            for (UserTokenListDTO userListDTO : userList) {
                try {
                    Long expireIn = this.cacheFactory.getExpireHashService().getKeyExpireTime("CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + userListDTO.getRefresh());
                    if (expireIn <= 0L) continue;
                    ret.add(userListDTO);
                }
                catch (CacheException e) {
                    log.error("checkExpireContent \u83b7\u53d6reids\u5931\u8d25 :{}", (Throwable)e);
                    ret.add(userListDTO);
                }
            }
            return ret;
        }
        return userList;
    }

    private List<UserTokenListDTO> deleteListContent(List<UserTokenListDTO> userList, String accessToken) {
        if (!CollectionUtils.isEmpty(userList)) {
            ArrayList<UserTokenListDTO> ret = new ArrayList<UserTokenListDTO>();
            for (UserTokenListDTO userListDTO : userList) {
                if (accessToken.equals(userListDTO.getAccess())) continue;
                ret.add(userListDTO);
            }
            return ret;
        }
        return userList;
    }

    private Response<Oauth2Token> createOauth2Token(UserLoginResp userLogin, String appId, String tenantNo) {
        String userId = userLogin.getUserId();
        if (StringUtils.isEmpty((Object)userId)) {
            return Response.createError((String)(ResponseCode.TOEKN_CREATE_FAIL.getMsg() + ",userId\u4e3a\u7a7a"), (String)(ResponseCode.TOEKN_CREATE_FAIL.getCode() + ""));
        }
        Oauth2Token oauth2Token = new Oauth2Token();
        oauth2Token.setAccess_token(CuscStringUtils.generateUuid());
        oauth2Token.setRefresh_token(CuscStringUtils.generateUuid());
        oauth2Token.setToken_type("bearer");
        oauth2Token.setScope("ALL");
        ApplicationDTO appBean = this.appConfigService.getAppConfigByCode(appId);
        oauth2Token.setExpires_in(appBean.getAccessTokenTerm());
        if (appBean.getIsDeviceLogin() != null && 1 == appBean.getIsDeviceLogin()) {
            this.kickOutByUserId(userId, tenantNo, appId);
        }
        oauth2Token.setInfo(userLogin);
        try {
            String organId = "";
            UserOrganDTO userOrgDto = new UserOrganDTO();
            userOrgDto.setUserId(userId);
            userOrgDto.setTenantNo(tenantNo);
            List userOrganList = this.userOrganService.queryByList(userOrgDto);
            if (!CollectionUtils.isEmpty((Collection)userOrganList)) {
                organId = userOrganList.stream().filter(userOrganDTO -> userId.equals(userOrganDTO.getUserId())).findFirst().map(UserOrganDTO::getOrganId).orElse("");
            }
            AccessTokenHashDTO accessTokenHashDTO = new AccessTokenHashDTO();
            accessTokenHashDTO.setUserId(userId);
            accessTokenHashDTO.setRefresh(oauth2Token.getRefresh_token());
            accessTokenHashDTO.setScope(oauth2Token.getScope());
            accessTokenHashDTO.setAppId(appId);
            accessTokenHashDTO.setTenantNo(tenantNo);
            accessTokenHashDTO.setOrganId(organId);
            this.cacheFactory.getExpireHashService().setExpireHash("CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + oauth2Token.getAccess_token(), (Object)accessTokenHashDTO, appBean.getAccessTokenTerm().intValue());
            RefreshTokenHashDTO refreshTokenHashDTO = new RefreshTokenHashDTO();
            refreshTokenHashDTO.setAccess(oauth2Token.getAccess_token());
            refreshTokenHashDTO.setUserId(userId);
            refreshTokenHashDTO.setScope(oauth2Token.getScope());
            refreshTokenHashDTO.setAppId(appId);
            refreshTokenHashDTO.setTenantNo(tenantNo);
            this.cacheFactory.getExpireHashService().setExpireHash("CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + oauth2Token.getRefresh_token(), (Object)refreshTokenHashDTO, appBean.getRefreshTokenTerm().intValue());
            String userTokenListKey = "CT:USER:AUTH:TOKEN:USER:" + tenantNo + ":" + userId;
            List<UserTokenListDTO> userList = this.cacheFactory.getExpireListService().getList(userTokenListKey, UserTokenListDTO.class);
            if (CollectionUtils.isEmpty((Collection)userList)) {
                userList = new ArrayList();
            }
            userList = this.checkExpireContent((List)userList);
            UserTokenListDTO userListDTO = new UserTokenListDTO();
            userListDTO.setAccess(oauth2Token.getAccess_token());
            userListDTO.setRefresh(oauth2Token.getRefresh_token());
            userListDTO.setAppId(appId);
            userList.add(userListDTO);
            this.cacheFactory.getExpireListService().delete(new String[]{userTokenListKey});
            this.cacheFactory.getExpireListService().setExpireList(userTokenListKey, userList, appBean.getAccessTokenTerm().intValue());
        }
        catch (CacheException e) {
            log.error("createOauth2Token \u5b58\u653ereids\u5931\u8d25 :{}", (Throwable)e);
            return Response.createError((String)ResponseCode.TOEKN_CREATE_FAIL.getMsg(), (String)(ResponseCode.TOEKN_CREATE_FAIL.getCode() + ""));
        }
        return Response.createSuccess((Object)oauth2Token);
    }

    private Response<Oauth2Token> createOauth2TokenXP(UserLoginResp userLogin, String appId, String tenantNo) {
        String userId = userLogin.getUserId();
        Oauth2Token oauth2Token = new Oauth2Token();
        oauth2Token.setAccess_token(CuscStringUtils.generateUuid());
        oauth2Token.setRefresh_token(CuscStringUtils.generateUuid());
        oauth2Token.setToken_type("bearer");
        oauth2Token.setScope("ALL");
        ApplicationDTO appBean = this.appConfigService.getAppConfigByCode(appId);
        oauth2Token.setExpires_in(appBean.getAccessTokenTerm());
        if (appBean.getIsDeviceLogin() != null && 1 == appBean.getIsDeviceLogin()) {
            this.kickOutByUserId(userId, tenantNo, appId);
        }
        oauth2Token.setInfo(userLogin);
        try {
            AccessTokenHashDTO accessTokenHashDTO = new AccessTokenHashDTO();
            accessTokenHashDTO.setUserId(userId);
            accessTokenHashDTO.setRefresh(oauth2Token.getRefresh_token());
            accessTokenHashDTO.setScope(oauth2Token.getScope());
            accessTokenHashDTO.setAppId(appId);
            accessTokenHashDTO.setTenantNo(tenantNo);
            this.cacheFactory.getExpireHashService().setExpireHash("CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + oauth2Token.getAccess_token(), (Object)accessTokenHashDTO, appBean.getAccessTokenTerm().intValue());
            RefreshTokenHashDTO refreshTokenHashDTO = new RefreshTokenHashDTO();
            refreshTokenHashDTO.setAccess(oauth2Token.getAccess_token());
            refreshTokenHashDTO.setUserId(userId);
            refreshTokenHashDTO.setScope(oauth2Token.getScope());
            refreshTokenHashDTO.setAppId(appId);
            refreshTokenHashDTO.setTenantNo(tenantNo);
            this.cacheFactory.getExpireHashService().setExpireHash("CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + oauth2Token.getRefresh_token(), (Object)refreshTokenHashDTO, appBean.getRefreshTokenTerm().intValue());
            String userTokenListKey = "CT:USER:AUTH:TOKEN:USER:" + tenantNo + ":" + userId;
            List<UserTokenListDTO> userList = this.cacheFactory.getExpireListService().getList(userTokenListKey, UserTokenListDTO.class);
            if (CollectionUtils.isEmpty((Collection)userList)) {
                userList = new ArrayList();
            }
            userList = this.checkExpireContent((List)userList);
            UserTokenListDTO userListDTO = new UserTokenListDTO();
            userListDTO.setAccess(oauth2Token.getAccess_token());
            userListDTO.setRefresh(oauth2Token.getRefresh_token());
            userListDTO.setAppId(appId);
            userList.add(userListDTO);
            this.cacheFactory.getExpireListService().delete(new String[]{userTokenListKey});
            this.cacheFactory.getExpireListService().setExpireList(userTokenListKey, userList, appBean.getAccessTokenTerm().intValue());
        }
        catch (CacheException e) {
            log.error("createOauth2Token \u5b58\u653ereids\u5931\u8d25 :{}", (Throwable)e);
            return Response.createError((String)ResponseCode.TOEKN_CREATE_FAIL.getMsg(), (String)(ResponseCode.TOEKN_CREATE_FAIL.getCode() + ""));
        }
        return Response.createSuccess((Object)oauth2Token);
    }
}

