/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.service.impl;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateReq;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateResp;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaVerificationReq;
import com.cusc.nirvana.user.auth.identification.service.ICaptchaService;
import com.cusc.nirvana.user.config.SmsPropertyConfig;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.wf.captcha.SpecCaptcha;
import java.awt.FontFormatException;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaptchaServiceImpl
implements ICaptchaService {
    private static final Logger log = LoggerFactory.getLogger(CaptchaServiceImpl.class);
    private static final int CAPTCHA_EXPIRE_TIME = 10800;
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    private SmsPropertyConfig smsPropertyConfig;

    public CaptchaCreateResp generateCaptcha(CaptchaCreateReq bean) {
        CaptchaCreateResp ret = new CaptchaCreateResp();
        ret.setRequestId(UUID.randomUUID().toString());
        SpecCaptcha captcha = new SpecCaptcha(bean.getCaptchaWidth(), bean.getCaptchaHeight(), bean.getCaptchaLength());
        captcha.setCharType(bean.getCaptchaType().getCode());
        String code = captcha.text().toLowerCase();
        try {
            this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:CAPTCHA:IMAGE:" + ret.getRequestId() + "_" + bean.getApplicationId(), (Object)code, 10800);
        }
        catch (CacheException e) {
            log.error("generateCaptcha \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            throw new CuscUserException(ResponseCode.REDIS_OPT_FAIL.getCode() + "", ResponseCode.REDIS_OPT_FAIL.getMsg());
        }
        try {
            captcha.setFont(1);
        }
        catch (IOException e) {
            log.error("generateCaptcha IOException \u8bbe\u7f6e\u5b57\u4f53\u5931\u8d25 \uff1a", (Throwable)e);
        }
        catch (FontFormatException e) {
            log.error("generateCaptcha FontFormatException \u8bbe\u7f6e\u5b57\u4f53\u5931\u8d25 \uff1a", (Throwable)e);
        }
        ret.setCaptchaImg(captcha.toBase64());
        return ret;
    }

    public boolean verificationCaptcha(CaptchaVerificationReq bean) {
        String redisCode;
        try {
            String imageCaptchaKey = "CT:USER:AUTH:CAPTCHA:IMAGE:" + bean.getRequestId() + "_" + bean.getApplicationId();
            redisCode = (String)this.cacheFactory.getExpireStringService().getValue(imageCaptchaKey, String.class);
            this.cacheFactory.getExpireStringService().delete(new String[]{imageCaptchaKey});
        }
        catch (CacheException e) {
            log.error("verificationCaptcha \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            throw new CuscUserException(ResponseCode.REDIS_OPT_FAIL.getCode() + "", ResponseCode.REDIS_OPT_FAIL.getMsg());
        }
        if (bean.getCaptchaValue().toLowerCase().equals(redisCode)) {
            return true;
        }
        log.info("verificationCaptcha false . param requestId:{} , input code:{} , redis code:{} ", new Object[]{bean.getRequestId(), bean.getCaptchaValue(), redisCode});
        return false;
    }

    public void checkSmsCaptchaErrorCount(String phone, String tenantNo, String appId) {
        try {
            String redisKey = "CT:USER:AUTH:SMS:CAPTCHA:ERROR_COUNT:" + phone + "_" + tenantNo + "_" + appId;
            Integer errorCount = (Integer)this.cacheFactory.getExpireStringService().getValue(redisKey, Integer.class);
            if (errorCount == null) {
                errorCount = 0;
            }
            Integer n = errorCount;
            Integer n2 = errorCount = Integer.valueOf(errorCount + 1);
            if (errorCount > this.smsPropertyConfig.errorCount) {
                this.cacheFactory.getExpireStringService().delete(new String[]{"CT:USER:AUTH:SMS:CAPTCHA:" + phone + "_" + tenantNo + "_" + appId});
                this.cacheFactory.getExpireStringService().delete(new String[]{redisKey});
                return;
            }
            this.cacheFactory.getExpireStringService().setExpireValue(redisKey, (Object)errorCount, 3600);
        }
        catch (CacheException e) {
            log.error("checkSmsCaptchaErrorCount \u68c0\u67e5\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u9519\u8bef\u6b21\u6570 \u8bbf\u95eeredis\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void delSmsCaptchaErrorCount(String phone, String tenantNo, String appId) {
        try {
            this.cacheFactory.getExpireStringService().delete(new String[]{"CT:USER:AUTH:SMS:CAPTCHA:ERROR_COUNT:" + phone + "_" + tenantNo + "_" + appId});
        }
        catch (CacheException e) {
            log.error("delSmsCaptchaErrorCount \u68c0\u67e5\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u9519\u8bef\u6b21\u6570 \u8bbf\u95eeredis\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

