/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.login;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.RandomIdReq;
import com.cusc.nirvana.user.auth.identification.dto.RandomIdResp;
import com.cusc.nirvana.user.auth.identification.service.IRandomIdService;
import com.cusc.nirvana.user.util.CuscRequestUtil;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/random"})
public class RandomIdController {
    private static final Logger log = LoggerFactory.getLogger(RandomIdController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomIdController.class);
    private static final int REQUEST_ID_EXPIRE_TIME = 10800;
    @Autowired
    private IRandomIdService randomIdService;

    @PostMapping(value={"/getRequestIdByCaptcha"})
    @ApiOperation(value="\u83b7\u53d6\u968f\u673a\u8bf7\u6c42id-\u56fe\u5f62\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u968f\u673a\u8bf7\u6c42id-\u56fe\u5f62\u9a8c\u8bc1\u7801")
    public Response<String> getRequestIdByCaptcha(@RequestBody RandomIdReq bean, HttpServletRequest request) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        Response ret = Response.createSuccess();
        ret.setData((Object)this.randomIdService.getRequestIdToRedis(bean.getApplicationId(), 10800, CuscRequestUtil.getIpAddr((HttpServletRequest)request)));
        return ret;
    }

    @PostMapping(value={"/getRequestIdByLogin"})
    @ApiOperation(value="\u83b7\u53d6\u968f\u673a\u8bf7\u6c42id-\u767b\u5f55\u5bc6\u7801\u52a0\u5bc6", notes="\u83b7\u53d6\u968f\u673a\u8bf7\u6c42id-\u767b\u5f55\u5bc6\u7801\u52a0\u5bc6")
    public Response<RandomIdResp> getRequestIdByLogin(@RequestBody RandomIdReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        int expireTime = 10800;
        if (bean.getExpireTime() != null && bean.getExpireTime() > 0) {
            expireTime = bean.getExpireTime();
        }
        String secretKey = CuscStringUtils.generateUuid().substring(16);
        String requestId = this.randomIdService.getRequestIdToRedis(bean.getApplicationId(), expireTime, secretKey);
        RandomIdResp ret = new RandomIdResp();
        ret.setSecretKey(secretKey);
        ret.setRequestId(requestId);
        return Response.createSuccess((Object)ret);
    }

    @PostMapping(value={"/getContentByRequestId"})
    @ApiOperation(value="\u83b7\u53d6\u968f\u673a\u8bf7\u6c42id\u5bf9\u5e94\u7684\u5185\u5bb9", notes="\u83b7\u53d6\u968f\u673a\u8bf7\u6c42id\u5bf9\u5e94\u7684\u5185\u5bb9")
    public Response<String> getContentByRequestId(@RequestBody RandomIdReq bean) {
        if (CuscStringUtils.isEmpty((String)bean.getRequestId()) || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        Response ret = Response.createSuccess();
        ret.setData((Object)this.randomIdService.getByRequestId(bean.getRequestId(), bean.getApplicationId()));
        return ret;
    }

    @PostMapping(value={"/delByRequestId"})
    @ApiOperation(value="\u5220\u9664\u968f\u673a\u8bf7\u6c42id\u5bf9\u5e94\u7684\u5185\u5bb9", notes="\u5220\u9664\u968f\u673a\u8bf7\u6c42id\u5bf9\u5e94\u7684\u5185\u5bb9")
    public Response<Boolean> delByRequestId(@RequestBody RandomIdReq bean) {
        if (CuscStringUtils.isEmpty((String)bean.getRequestId()) || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        Response ret = Response.createSuccess();
        ret.setData((Object)this.randomIdService.delRequestIdRedis(bean.getRequestId(), bean.getApplicationId()));
        return ret;
    }
}

